/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.visitor;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Property;
import io.micronaut.core.annotation.AccessorsStyle;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.configuration.ConfigurationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.validation.RequiresValidation;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Map;

@Internal
public class ConfigurationReaderVisitor
implements TypeElementVisitor<ConfigurationReader, Object> {
    private static final String ANN_CONFIGURATION_ADVICE = "io.micronaut.runtime.context.env.ConfigurationAdvice";
    private final ConfigurationMetadataBuilder metadataBuilder = ConfigurationMetadataBuilder.INSTANCE;
    private String[] readPrefixes;

    @Override
    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    @Override
    public void finish(VisitorContext visitorContext) {
        this.reset();
    }

    @Override
    public void visitClass(ClassElement classElement, VisitorContext context) {
        this.reset();
        if (!classElement.hasStereotype(ConfigurationReader.class)) {
            return;
        }
        ConfigurationMetadata configurationMetadata = this.metadataBuilder.visitProperties(classElement);
        if (configurationMetadata != null) {
            classElement.annotate(ConfigurationReader.class, builder -> builder.member("prefix", configurationMetadata.getName()));
        }
        if (classElement.isInterface()) {
            classElement.annotate(ANN_CONFIGURATION_ADVICE);
        }
        if (classElement.hasStereotype(RequiresValidation.class)) {
            classElement.annotate(Introspected.class);
        }
        AnnotationMetadata annotationMetadata = classElement.getAnnotationMetadata();
        this.readPrefixes = annotationMetadata.getValue(AccessorsStyle.class, "readPrefixes", String[].class).orElse(new String[]{"get"});
    }

    private void reset() {
        this.readPrefixes = null;
    }

    @Override
    public void visitMethod(MethodElement method, VisitorContext context) {
        if (method.isAbstract()) {
            this.visitAbstractMethod(method, context);
        }
    }

    public static boolean isPropertyParameter(ParameterElement parameter, VisitorContext visitorContext) {
        ClassElement genericType = parameter.getGenericType();
        return ConfigurationReaderVisitor.isPropertyParameter(genericType, visitorContext);
    }

    private static boolean isPropertyParameter(ClassElement genericType, VisitorContext visitorContext) {
        ClassElement t;
        if (genericType.isOptional() || genericType.isContainerType() || ConfigurationReaderVisitor.isProvider(genericType)) {
            ClassElement finalParameterType = genericType;
            genericType = genericType.getOptionalValueType().or(finalParameterType::getFirstTypeArgument).orElse(genericType);
            genericType = visitorContext.getClassElement(genericType.getCanonicalName()).orElse(genericType);
        } else if (genericType.isAssignable(Map.class) && (t = genericType.getTypeArguments().get("V")) != null) {
            genericType = t;
        }
        return !genericType.hasStereotype("jakarta.inject.Scope") && !genericType.hasStereotype(Bean.class);
    }

    private static boolean isProvider(ClassElement genericType) {
        String name = genericType.getName();
        for (String type : DefaultArgument.PROVIDER_TYPES) {
            if (!name.equals(type)) continue;
            return true;
        }
        return false;
    }

    private void visitAbstractMethod(MethodElement method, VisitorContext context) {
        String methodName = method.getName();
        if (!this.isGetter(methodName)) {
            context.fail("Only getter methods are allowed on @ConfigurationProperties interfaces: " + method + ". You can change the accessors using @AccessorsStyle annotation", method.getOwningType());
            return;
        }
        if (method.hasParameters()) {
            context.fail("Only zero argument getter methods are allowed on @ConfigurationProperties interfaces: " + method, method);
            return;
        }
        if (method.getReturnType().isVoid()) {
            context.fail("Getter methods must return a value @ConfigurationProperties interfaces: " + method, method);
            return;
        }
        boolean isPropertyParameter = ConfigurationReaderVisitor.isPropertyParameter(method.getGenericReturnType(), context);
        if (isPropertyParameter) {
            String propertyName = this.getPropertyNameForGetter(methodName);
            String path = this.metadataBuilder.visitProperty(method.getOwningType(), method.getOwningType(), method.getReturnType(), propertyName, ConfigurationMetadataBuilder.resolveJavadocDescription(method), method.getAnnotationMetadata().stringValue(Bindable.class, "defaultValue").orElse(null)).getPath();
            method.annotate(Property.class, builder -> builder.member("name", path));
        }
        method.annotate(ANN_CONFIGURATION_ADVICE, annBuilder -> {
            if (!isPropertyParameter) {
                annBuilder.member("bean", true);
            }
            if (method.hasStereotype(EachProperty.class)) {
                annBuilder.member("iterable", true);
            }
        });
    }

    private String getPropertyNameForGetter(String methodName) {
        return NameUtils.getPropertyNameForGetter((String)methodName, (String[])this.readPrefixes);
    }

    private boolean isGetter(String methodName) {
        return NameUtils.isReaderName((String)methodName, (String[])this.readPrefixes);
    }
}

