/*
 * Decompiled with CFR 0.152.
 */
package io.microlam.logging;

import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class OneLineSimpleFormatter
extends SimpleFormatter {
    private final LogManager manager = LogManager.getLogManager();
    private final boolean oneNewLineOnly;

    public OneLineSimpleFormatter() {
        this.oneNewLineOnly = this.manager == null || this.getBooleanProperty(this.getClass().getName() + ".oneNewLineOnly", false);
    }

    public OneLineSimpleFormatter(boolean oneNewLineOnly) {
        this.oneNewLineOnly = oneNewLineOnly;
    }

    protected boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = this.manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public String format(LogRecord record) {
        String result = super.format(record);
        return this.oneNewLineOnly ? result.replace('\n', '\r') + "\n" : result;
    }
}

