/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.annotationProcessing;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class Formatter {
    private static Configuration cfg = new Configuration(Configuration.VERSION_2_3_29);
    private final String templateName;
    private final Map<String, Object> model;

    public Formatter(String template, Map<String, Object> model) {
        this.templateName = template;
        this.model = model;
    }

    public String apply() throws TemplateException, IOException {
        Template tempplate = cfg.getTemplate(this.templateName);
        StringWriter out = new StringWriter();
        tempplate.process(this.model, (Writer)out);
        return out.toString();
    }

    static {
        cfg.setClassForTemplateLoading(Formatter.class, "/templates");
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
    }
}

