/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.util;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public final class XmlHelper {
    public static String asText(Node node, boolean pretty) {
        StreamResult result = new StreamResult(new StringWriter());
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        if (pretty) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        if (node instanceof Document) {
            DocumentType doctype = ((Document)node).getDoctype();
            if (null != doctype) {
                String publicId;
                String systemId = doctype.getSystemId();
                if (null != systemId && !systemId.isEmpty()) {
                    transformer.setOutputProperty("doctype-system", systemId);
                }
                if (null != (publicId = doctype.getPublicId()) && !publicId.isEmpty()) {
                    transformer.setOutputProperty("doctype-public", publicId);
                }
            }
        } else {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.transform(new DOMSource(node), result);
        return result.getWriter().toString();
    }

    private XmlHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

