/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.util;

import io.markdom.util.Attribute;
import io.markdom.util.Attributes;
import io.markdom.util.Node;
import io.markdom.util.NodeSelection;
import io.markdom.util.Nodes;
import io.markdom.util.ObjectHelper;
import java.util.Optional;

public final class Element
implements Node {
    private final String tagName;
    private final Attributes attributes;
    private final Nodes nodes;

    public Element(String tagName) {
        this(tagName, new Attributes(), new Nodes());
    }

    public Element(String tagName, Attributes attributes, Nodes nodes) {
        this.tagName = ObjectHelper.notNull("tag name", tagName);
        this.attributes = ObjectHelper.notNull("attributes", attributes);
        this.nodes = ObjectHelper.notNull("nodes", nodes);
    }

    public Element add(Attribute attribute) {
        this.attributes.add(ObjectHelper.notNull("attribute", attribute));
        return this;
    }

    public Element add(Optional<Attribute> attribute) {
        ObjectHelper.notNull("attribute", attribute).map(this::add);
        return this;
    }

    public Element add(Node node) {
        this.nodes.add(ObjectHelper.notNull("node", node));
        return this;
    }

    @Override
    public <Result> Result select(NodeSelection<Result> selection) {
        return selection.select(this);
    }

    public String getTagName() {
        return this.tagName;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Nodes getNodes() {
        return this.nodes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Element)) {
            return false;
        }
        Element other = (Element)o;
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        Attributes this$attributes = this.getAttributes();
        Attributes other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Nodes this$nodes = this.getNodes();
        Nodes other$nodes = other.getNodes();
        return !(this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        Attributes $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Nodes $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        return result;
    }

    public String toString() {
        return "Element(tagName=" + this.getTagName() + ", attributes=" + this.getAttributes() + ", nodes=" + this.getNodes() + ")";
    }
}

