/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.util;

import java.util.LinkedList;
import java.util.List;

public final class StringUtil {
    public static int longestSequenceLength(CharSequence value, char character) {
        int maxLength = 0;
        int currentLength = 0;
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            if (character == value.charAt(i)) {
                ++currentLength;
                continue;
            }
            maxLength = Math.max(maxLength, currentLength);
            currentLength = 0;
        }
        return Math.max(maxLength, currentLength);
    }

    public static int leadingSequenceLength(CharSequence value, char character) {
        int length = 0;
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            if (character == value.charAt(i)) {
                ++length;
                continue;
            }
            return length;
        }
        return length;
    }

    public static boolean consistsOnlyOf(CharSequence value, char character) {
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            if (character == value.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean consistsOnlyOfAnyOf(CharSequence value, char[] characters) {
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char character = value.charAt(i);
            if (StringUtil.contains(characters, character)) continue;
            return false;
        }
        return true;
    }

    private static boolean contains(char[] characters, char character) {
        int n = characters.length;
        for (int i = 0; i < n; ++i) {
            if (characters[i] != character) continue;
            return true;
        }
        return false;
    }

    public static String repeat(char character, int length) {
        char[] buffer = new char[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = character;
        }
        return new String(buffer);
    }

    public static List<String> splitLines(String string) {
        LinkedList<String> lines = new LinkedList<String>();
        while (!string.isEmpty()) {
            int index = string.indexOf(10);
            if (-1 == index) {
                lines.add(string);
                string = "";
                continue;
            }
            if (0 != index && '\r' == string.charAt(index - 1)) {
                lines.add(string.substring(0, index - 1));
                string = string.substring(index + 1);
                continue;
            }
            lines.add(string.substring(0, index));
            string = string.substring(index + 1);
        }
        return lines;
    }

    private StringUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

