/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.Position;
import io.markdom.handler.text.commonmark.Shred;
import io.markdom.handler.text.commonmark.ShredType;
import io.markdom.util.StringUtil;

final class TextShred
implements Shred {
    private final StringBuilder buffer = new StringBuilder();
    private boolean leadingSpace;
    private boolean trailingSpace;
    private boolean isLeadingTextShredInLine;
    private boolean isTrailingTextShredInLine;
    private boolean isFollowedByLinkBeginShred;

    TextShred(String text) {
        this.appendText(text);
    }

    @Override
    public ShredType getType() {
        return ShredType.TEXT;
    }

    @Override
    public boolean appendText(String text) {
        block3: for (char character : text.toCharArray()) {
            switch (character) {
                case '\t': 
                case ' ': {
                    if (this.isEmpty()) {
                        this.leadingSpace = true;
                        continue block3;
                    }
                    this.trailingSpace = true;
                    continue block3;
                }
                default: {
                    if (this.trailingSpace) {
                        this.buffer.append(' ');
                        this.trailingSpace = false;
                    }
                    this.buffer.append(character);
                }
            }
        }
        return true;
    }

    @Override
    public boolean consumesSpace(Position position) {
        return true;
    }

    @Override
    public boolean hasSpace(Position position) {
        switch (position) {
            case LEADING: {
                return this.leadingSpace;
            }
            case TRAILING: {
                return this.trailingSpace;
            }
        }
        throw new InternalError("Unknown space position: " + (Object)((Object)position));
    }

    @Override
    public void setSpace(Position position, boolean space) {
        switch (position) {
            case LEADING: {
                this.leadingSpace = space;
                break;
            }
            case TRAILING: {
                this.trailingSpace = space;
            }
        }
    }

    @Override
    public void setHint(Position position, ShredType type) {
        if (Position.LEADING == position && ShredType.LINE_START == type) {
            this.isLeadingTextShredInLine = true;
        }
        if (Position.TRAILING == position && ShredType.LINE_END == type) {
            this.isTrailingTextShredInLine = true;
        }
        if (Position.TRAILING == position && ShredType.LINK_BEGIN == type) {
            this.isFollowedByLinkBeginShred = true;
        }
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.buffer.length();
    }

    @Override
    public void appendTo(LineAppendable appendable) {
        if (this.leadingSpace) {
            appendable.append(' ');
        }
        if (this.isLeadingTextShredInLine && this.isTrailingTextShredInLine) {
            this.processAsOnlyShredInLine(appendable);
        } else if (this.isLeadingTextShredInLine) {
            this.processAsLeadingShredInLine(appendable, false);
        } else {
            this.appendAndEscapeBuffer(appendable, 0, false);
        }
        if (this.trailingSpace) {
            appendable.append(' ');
        }
    }

    private void processAsOnlyShredInLine(LineAppendable appendable) {
        if (this.isHeadingIndicator() || this.isFencedCodeIndicator() || this.isDivisionIndicator() || this.isUnorderedListItemIndicator()) {
            appendable.append('\\');
            appendable.append(this.buffer);
        } else {
            this.processAsLeadingShredInLine(appendable, true);
        }
    }

    private boolean isHeadingIndicator() {
        if (this.buffer.length() <= 6 && StringUtil.consistsOnlyOf((CharSequence)this.buffer, (char)'#')) {
            return true;
        }
        return StringUtil.consistsOnlyOf((CharSequence)this.buffer, (char)'=');
    }

    private boolean isFencedCodeIndicator() {
        return this.buffer.length() >= 3 && StringUtil.leadingSequenceLength((CharSequence)this.buffer, (char)'~') >= 3;
    }

    private boolean isDivisionIndicator() {
        if (this.buffer.length() >= 3) {
            if (StringUtil.consistsOnlyOfAnyOf((CharSequence)this.buffer, (char[])new char[]{'-', ' '})) {
                return true;
            }
            if (StringUtil.consistsOnlyOfAnyOf((CharSequence)this.buffer, (char[])new char[]{'*', ' '})) {
                return true;
            }
            if (StringUtil.consistsOnlyOfAnyOf((CharSequence)this.buffer, (char[])new char[]{'_', ' '})) {
                return true;
            }
        }
        return false;
    }

    private boolean isUnorderedListItemIndicator() {
        char character;
        return this.buffer.length() == 1 && ('-' == (character = this.buffer.charAt(0)) || '+' == character || '*' == character);
    }

    private void processAsLeadingShredInLine(LineAppendable appendable, boolean isOnlyShredInLine) {
        if (this.startsWithHeadingIndicator() || this.startsWithFencedCodeIndicator() || this.startsWithUnorderedListItemIndicator()) {
            appendable.append('\\');
            appendable.append(this.buffer.charAt(0));
            this.appendAndEscapeBuffer(appendable, 1, isOnlyShredInLine);
        } else {
            this.appendAndEscapeBuffer(appendable, 0, isOnlyShredInLine);
        }
    }

    private boolean startsWithHeadingIndicator() {
        int leadingHashSequenceLength = StringUtil.leadingSequenceLength((CharSequence)this.buffer, (char)'#');
        return leadingHashSequenceLength > 0 && leadingHashSequenceLength <= 6 && this.isFollowedBySpace(leadingHashSequenceLength - 1);
    }

    private boolean startsWithFencedCodeIndicator() {
        return StringUtil.leadingSequenceLength((CharSequence)this.buffer, (char)'~') >= 3;
    }

    private boolean startsWithUnorderedListItemIndicator() {
        char character;
        if (this.buffer.length() > 0 && ('-' == (character = this.buffer.charAt(0)) || '+' == character || '*' == character)) {
            return this.isFollowedBySpace(0);
        }
        return false;
    }

    private boolean isFollowedBySpace(int i) {
        return this.buffer.length() > i + 1 && this.buffer.charAt(i + 1) == ' ' || this.buffer.length() == i + 1 && this.trailingSpace;
    }

    private void appendAndEscapeBuffer(LineAppendable appendable, int fromIndex, boolean isOnlyShredInLine) {
        boolean onlyNumbersSoFar = false;
        int n = this.buffer.length();
        for (int i = fromIndex; i < n; ++i) {
            char character = this.buffer.charAt(i);
            boolean isFirstCharacter = i == 0;
            boolean isLastCharacter = i == n - 1;
            boolean couldBeOrderedList = onlyNumbersSoFar && (isOnlyShredInLine || this.isFollowedBySpace(i));
            this.appendAndEscapeCharacter(appendable, character, couldBeOrderedList, isLastCharacter);
            onlyNumbersSoFar = this.onlyNumbersSoFar(character, onlyNumbersSoFar, isFirstCharacter);
        }
    }

    private void appendAndEscapeCharacter(LineAppendable appendable, char character, boolean couldBeOrderedList, boolean isLastCharacter) {
        switch (character) {
            case '*': 
            case '<': 
            case '[': 
            case '\\': 
            case '_': 
            case '`': {
                appendable.append('\\');
                appendable.append(character);
                break;
            }
            case '!': {
                if (this.isFollowedByLinkBeginShred && isLastCharacter) {
                    appendable.append('\\');
                }
                appendable.append(character);
                break;
            }
            case ')': 
            case '.': {
                if (couldBeOrderedList) {
                    appendable.append('\\');
                }
                appendable.append(character);
                break;
            }
            default: {
                appendable.append(character);
            }
        }
    }

    private boolean onlyNumbersSoFar(char character, boolean onlyNumbersSoFar, boolean isFirstCharacter) {
        if (isFirstCharacter) {
            onlyNumbersSoFar = this.isNumber(character);
        } else if (onlyNumbersSoFar && !this.isNumber(character)) {
            onlyNumbersSoFar = false;
        }
        return onlyNumbersSoFar;
    }

    private boolean isNumber(char character) {
        return character >= '0' && character <= '9';
    }

    public String toString() {
        return "(" + this.leadingSpace + ", " + this.buffer + ", " + this.trailingSpace + ")";
    }
}

