/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.handler.text.commonmark.CommonmarkTextConfiguration;
import io.markdom.handler.text.commonmark.Indentation;
import io.markdom.util.StringUtil;

final class OrderedListIndentation
implements Indentation {
    private final char commitCharacter;
    private int nextIndex;
    private String followingString;

    OrderedListIndentation(CommonmarkTextConfiguration configuration, Integer startIndex) {
        this.commitCharacter = configuration.getOrderedListOption().getCommitCharacter();
        this.nextIndex = startIndex;
    }

    @Override
    public void advance() {
        this.followingString = null;
    }

    @Override
    public String get() {
        if (null != this.followingString) {
            return this.followingString;
        }
        String indexString = Integer.toString(this.nextIndex++);
        this.followingString = StringUtil.repeat((char)' ', (int)(indexString.length() + 2));
        return indexString + this.commitCharacter + " ";
    }
}

