/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.Position;
import io.markdom.handler.text.commonmark.Shred;
import io.markdom.handler.text.commonmark.ShredType;
import java.util.Optional;

final class LinkEndShred
implements Shred {
    private String uri;
    private Optional<String> title;

    LinkEndShred(String uri, Optional<String> title) {
        this.uri = uri.trim();
        this.title = title.map(String::trim);
    }

    @Override
    public ShredType getType() {
        return ShredType.LINK_END;
    }

    @Override
    public boolean blocksSpace(Position position) {
        return Position.LEADING == position;
    }

    @Override
    public void appendTo(LineAppendable appendable) {
        appendable.append("](");
        appendable.append(this.uri);
        appendable.append(this.mapTitle().orElse(""));
        appendable.append(")");
    }

    private Optional<String> mapTitle() {
        return this.title.map(title -> title.isEmpty() ? "" : " " + title);
    }

    public String toString() {
        return "(" + this.uri + ", " + this.title + ")";
    }
}

