/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.Position;
import io.markdom.handler.text.commonmark.Shred;
import io.markdom.handler.text.commonmark.ShredType;

final class LineEndShred
implements Shred {
    private String lineBreakString;
    private boolean hard;

    LineEndShred(boolean hard, String lineBreakString) {
        this.lineBreakString = lineBreakString;
        this.appendLineBreak(hard);
    }

    @Override
    public ShredType getType() {
        return ShredType.LINE_END;
    }

    @Override
    public boolean isLineEnding() {
        return true;
    }

    @Override
    public boolean appendLineBreak(boolean hard) {
        if (hard) {
            this.hard = hard;
        }
        return true;
    }

    @Override
    public boolean consumesSpace(Position position) {
        return Position.LEADING == position;
    }

    @Override
    public void appendTo(LineAppendable appendable) {
        if (this.hard) {
            appendable.append(this.lineBreakString);
        }
        appendable.endLine();
    }

    public String toString() {
        return "(" + this.hard + ")";
    }

    public boolean isHard() {
        return this.hard;
    }
}

