/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.handler.text.commonmark.CommonmarkTextConfiguration;
import io.markdom.handler.text.commonmark.IndentationSupplier;
import io.markdom.handler.text.commonmark.LineAppendable;

public final class IndentingAppendable
implements LineAppendable {
    private final String lineEndString;
    private final IndentationSupplier supplier;
    private final Appendable appendable;
    private boolean pendingLineEnd;

    IndentingAppendable(CommonmarkTextConfiguration configuration, IndentationSupplier indentationSupplier, Appendable appendable) {
        this.lineEndString = configuration.getLineEndOption().getLineEndString();
        this.supplier = indentationSupplier;
        this.appendable = appendable;
    }

    @Override
    public void startLine() {
        if (this.pendingLineEnd) {
            this.appendable.append(this.lineEndString);
        }
        this.appendable.append(this.supplier.get());
    }

    @Override
    public void append(char character) {
        this.appendable.append(character);
    }

    @Override
    public void append(CharSequence characters) {
        this.appendable.append(characters);
    }

    @Override
    public void endLine() {
        this.pendingLineEnd = true;
    }
}

