/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.handler.text.commonmark.CommentBlockSection;
import io.markdom.handler.text.commonmark.CommonmarkTextConfiguration;
import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.Section;
import io.markdom.util.StringUtil;
import java.util.List;
import java.util.ListIterator;

final class IndentedCodeBlockSection
implements Section {
    private final String emptyIndentedCodeBlockComment;
    private final String code;

    IndentedCodeBlockSection(CommonmarkTextConfiguration configuration, String code) {
        this.emptyIndentedCodeBlockComment = configuration.getEmptyIndentedCodeBlockComment();
        this.code = code;
    }

    @Override
    public void appendTo(LineAppendable appendable) {
        List<String> lines = this.removeLeadingAndTrailingEmptyLines(StringUtil.splitLines((String)this.code));
        if (lines.isEmpty()) {
            new CommentBlockSection(this.emptyIndentedCodeBlockComment).appendTo(appendable);
        } else {
            for (String line : lines) {
                appendable.startLine();
                appendable.append("    ");
                appendable.append(line);
                appendable.endLine();
            }
        }
    }

    private List<String> removeLeadingAndTrailingEmptyLines(List<String> lines) {
        return this.removeTrailingEmptyLines(this.removeLeadingEmptyLines(lines));
    }

    private List<String> removeLeadingEmptyLines(List<String> lines) {
        ListIterator<String> iterator = lines.listIterator();
        while (iterator.hasNext() && iterator.next().trim().isEmpty()) {
            iterator.remove();
        }
        return lines;
    }

    private List<String> removeTrailingEmptyLines(List<String> lines) {
        ListIterator<String> iterator = lines.listIterator(lines.size());
        while (iterator.hasPrevious() && iterator.previous().trim().isEmpty()) {
            iterator.remove();
        }
        return lines;
    }
}

