/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.Position;
import io.markdom.handler.text.commonmark.Shred;
import io.markdom.handler.text.commonmark.ShredType;
import java.util.Optional;

final class ImageShred
implements Shred {
    private String uri;
    private Optional<String> title;
    private Optional<String> alternative;

    ImageShred(String uri, Optional<String> title, Optional<String> alternative) {
        this.uri = uri.trim();
        this.title = title.map(String::trim);
        this.alternative = alternative.map(String::trim);
    }

    @Override
    public ShredType getType() {
        return ShredType.IMAGE;
    }

    @Override
    public boolean blocksSpace(Position position) {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.uri.isEmpty();
    }

    @Override
    public void appendTo(LineAppendable appendable) {
        appendable.append("![");
        appendable.append(this.alternative.orElse(""));
        appendable.append("](");
        appendable.append(this.uri);
        appendable.append(this.mapTitle().orElse(""));
        appendable.append(")");
    }

    private Optional<String> mapTitle() {
        return this.title.map(title -> title.isEmpty() ? "" : " " + title);
    }

    public String toString() {
        return "(" + this.uri + ", " + this.title + ", " + this.alternative + ")";
    }
}

