/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.text.commonmark.CommonmarkTextConfiguration;
import io.markdom.handler.text.commonmark.ContentBuffer;
import io.markdom.handler.text.commonmark.ContentSection;
import io.markdom.handler.text.commonmark.HeadingAppendable;
import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.util.StringUtil;

final class HeadingBlockSection
implements ContentSection {
    private final ContentBuffer buffer;
    private final String levelString;

    public HeadingBlockSection(CommonmarkTextConfiguration configuration, MarkdomHeadingLevel level) {
        this.levelString = StringUtil.repeat((char)'#', (int)(level.ordinal() + 1)) + " ";
        this.buffer = new ContentBuffer(configuration, "");
    }

    @Override
    public void appendTo(LineAppendable appendable) {
        appendable.startLine();
        appendable.append(this.levelString);
        this.buffer.appendTo(new HeadingAppendable(appendable, " "));
        appendable.endLine();
    }

    public HeadingBlockSection(ContentBuffer buffer, String levelString) {
        this.buffer = buffer;
        this.levelString = levelString;
    }

    @Override
    public ContentBuffer getBuffer() {
        return this.buffer;
    }
}

