/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.handler.text.commonmark.CommonmarkTextConfiguration;
import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.Section;
import io.markdom.util.StringUtil;
import java.util.List;
import java.util.Optional;

final class FencedCodeBlockSection
implements Section {
    private final String fence;
    private final String code;
    private final Optional<String> hint;

    public FencedCodeBlockSection(CommonmarkTextConfiguration configuration, String code, Optional<String> hint) {
        char fenceCharacter = configuration.getCodeFenceOption().getFenceCharacter();
        int fenceLength = Math.max(3, StringUtil.longestSequenceLength((CharSequence)code, (char)fenceCharacter) + 1);
        this.fence = StringUtil.repeat((char)fenceCharacter, (int)fenceLength);
        this.code = code;
        this.hint = hint;
    }

    @Override
    public void appendTo(LineAppendable appendable) {
        this.appendLeadingFence(appendable);
        this.appendCode(appendable);
        this.appendTrailingFence(appendable);
    }

    private void appendLeadingFence(LineAppendable appendable) {
        appendable.startLine();
        appendable.append(this.fence);
        this.hint.ifPresent(hintString -> {
            appendable.append(' ');
            appendable.append(hintString.trim());
        });
        appendable.endLine();
    }

    private void appendCode(LineAppendable appendable) {
        List lines = StringUtil.splitLines((String)this.code);
        for (String line : lines) {
            appendable.startLine();
            appendable.append(line);
            appendable.endLine();
        }
    }

    private void appendTrailingFence(LineAppendable appendable) {
        appendable.startLine();
        appendable.append(this.fence);
        appendable.endLine();
    }
}

