/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.Position;
import io.markdom.handler.text.commonmark.Shred;
import io.markdom.handler.text.commonmark.ShredType;

final class EmphasisEndShred
implements Shred {
    private MarkdomEmphasisLevel level;
    private String bounderyString;

    EmphasisEndShred(MarkdomEmphasisLevel level, String bounderyString) {
        this.level = level;
        this.bounderyString = bounderyString;
    }

    @Override
    public ShredType getType() {
        return ShredType.EMPHASIS_END;
    }

    @Override
    public boolean isEmphasisEnd(MarkdomEmphasisLevel level) {
        return level == this.level;
    }

    @Override
    public boolean blocksSpace(Position position) {
        return Position.LEADING == position;
    }

    @Override
    public void appendTo(LineAppendable appendable) {
        appendable.append(this.bounderyString);
    }

    public String toString() {
        return "(" + this.bounderyString + ")";
    }
}

