/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.Position;
import io.markdom.handler.text.commonmark.Shred;
import io.markdom.handler.text.commonmark.ShredType;

final class EmphasisBeginShred
implements Shred {
    private MarkdomEmphasisLevel level;
    private String bounderyString;

    EmphasisBeginShred(MarkdomEmphasisLevel level, String bounderyString) {
        this.level = level;
        this.bounderyString = bounderyString;
    }

    @Override
    public ShredType getType() {
        return ShredType.EMPHASIS_BEGIN;
    }

    @Override
    public boolean isDelimiterBeginning() {
        return true;
    }

    @Override
    public boolean isEmphasisBegin(MarkdomEmphasisLevel level) {
        return level == this.level;
    }

    @Override
    public boolean blocksSpace(Position position) {
        return Position.TRAILING == position;
    }

    @Override
    public void appendTo(LineAppendable appendable) {
        appendable.append(this.bounderyString);
    }

    public String toString() {
        return "(" + this.bounderyString + ")";
    }
}

