/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.handler.text.commonmark.CodeShred;
import io.markdom.handler.text.commonmark.CommonmarkTextConfiguration;
import io.markdom.handler.text.commonmark.EmphasisBeginShred;
import io.markdom.handler.text.commonmark.EmphasisEndShred;
import io.markdom.handler.text.commonmark.ImageShred;
import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.LineEndShred;
import io.markdom.handler.text.commonmark.LineStartShred;
import io.markdom.handler.text.commonmark.LinkBeginShred;
import io.markdom.handler.text.commonmark.LinkEndShred;
import io.markdom.handler.text.commonmark.Position;
import io.markdom.handler.text.commonmark.Shred;
import io.markdom.handler.text.commonmark.TextShred;
import io.markdom.util.StringUtil;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;

final class ContentBuffer {
    private final CommonmarkTextConfiguration configuration;
    private final List<Shred> shreds = new LinkedList<Shred>();
    private final Map<MarkdomEmphasisLevel, String> bounderyStrings;
    private final Set<MarkdomEmphasisLevel> openLevels;
    private final Stack<MarkdomEmphasisLevel> ignoreLevels;
    private final String emptyParagraphString;
    private boolean pendingLineBreak;
    private int linkDepth;
    private boolean skippedEmptyLink;

    public ContentBuffer(CommonmarkTextConfiguration configuration, String emptyParagraphString) {
        this.configuration = configuration;
        this.bounderyStrings = new EnumMap<MarkdomEmphasisLevel, String>(MarkdomEmphasisLevel.class);
        this.openLevels = EnumSet.noneOf(MarkdomEmphasisLevel.class);
        this.ignoreLevels = new Stack();
        for (MarkdomEmphasisLevel level : MarkdomEmphasisLevel.values()) {
            this.bounderyStrings.put(level, this.getBounderyStringByLevel(level));
        }
        this.emptyParagraphString = emptyParagraphString;
        this.beginNewLine();
    }

    private String getBounderyStringByLevel(MarkdomEmphasisLevel level) {
        return StringUtil.repeat((char)this.getBounderyCharacterByLevel(level), (int)(level.ordinal() + 1));
    }

    private char getBounderyCharacterByLevel(MarkdomEmphasisLevel level) {
        switch (level) {
            case LEVEL_1: {
                return this.configuration.getEmphasisLevel1Option().getBounderyCharacter();
            }
            case LEVEL_2: {
                return this.configuration.getEmphasisLevel2Option().getBounderyCharacter();
            }
        }
        throw new InternalError("Unknown emphasis level: " + level);
    }

    public void appendCode(String code) {
        CodeShred codeShred;
        this.prepareLine();
        if (!this.lastShred().appendCode(code) && !(codeShred = new CodeShred(code)).isEmpty()) {
            this.shreds.add(codeShred);
        }
    }

    public void appendEmphasisBegin(MarkdomEmphasisLevel level) {
        if (this.openLevels.contains(level)) {
            this.ignoreLevels.push(level);
        } else {
            this.openLevels.add(level);
            this.prepareLine();
            if (this.lastShred().isEmphasisEnd(level)) {
                this.removeLastShred();
            } else {
                this.shreds.add(new EmphasisBeginShred(level, this.bounderyStrings.get(level)));
            }
        }
    }

    public void appendEmphasisEnd(MarkdomEmphasisLevel level) {
        if (!this.ignoreLevels.isEmpty() && level == this.ignoreLevels.peek()) {
            this.ignoreLevels.pop();
        } else {
            this.openLevels.remove(level);
            LineEndShred lineEndShred = null;
            if (this.lastShred().isLineEnding()) {
                lineEndShred = (LineEndShred)this.removeLastShred();
            }
            if (this.lastShred().isEmphasisBegin(level)) {
                this.removeLastShred();
            } else {
                this.shreds.add(new EmphasisEndShred(level, this.bounderyStrings.get(level)));
            }
            if (null != lineEndShred) {
                this.shreds.add(lineEndShred);
            }
            if (this.lastShred().isLineBeginning()) {
                this.unprepareLine();
            }
        }
    }

    public void appendImage(String uri, Optional<String> title, Optional<String> alternative) {
        this.prepareLine();
        ImageShred imageShred = new ImageShred(uri, title, alternative);
        if (!imageShred.isEmpty()) {
            this.shreds.add(imageShred);
        }
    }

    public void appendLinkBegin(String uri) {
        if (0 == this.linkDepth) {
            if (uri.trim().isEmpty()) {
                this.skippedEmptyLink = true;
            } else {
                this.prepareLine();
                this.shreds.add(new LinkBeginShred());
            }
        }
        ++this.linkDepth;
    }

    public void appendLinkEnd(String uri, Optional<String> title) {
        --this.linkDepth;
        if (0 == this.linkDepth) {
            if (this.skippedEmptyLink) {
                this.skippedEmptyLink = false;
            } else {
                LineEndShred lineEndShred = null;
                if (this.lastShred().isLineEnding()) {
                    lineEndShred = (LineEndShred)this.removeLastShred();
                }
                this.shreds.add(new LinkEndShred(uri, title));
                if (null != lineEndShred) {
                    this.shreds.add(lineEndShred);
                }
                if (this.lastShred().isLineBeginning()) {
                    this.unprepareLine();
                }
            }
        }
    }

    public void appendText(String text) {
        TextShred textShred;
        this.prepareLine();
        if (!this.lastShred().appendText(text) && !(textShred = new TextShred(text)).isEmpty()) {
            this.shreds.add(textShred);
        }
    }

    public void appendLineBreak(boolean hard) {
        if (!this.lastShred().appendLineBreak(hard)) {
            this.shreds.add(new LineEndShred(hard, this.configuration.getLineBreakOption().getLineBreakString()));
            this.pendingLineBreak = true;
        }
    }

    private void prepareLine() {
        if (this.pendingLineBreak) {
            this.pendingLineBreak = false;
            this.beginNewLine();
            this.moveLineBreakInFrontOfBeginnings();
        }
    }

    private void beginNewLine() {
        this.shreds.add(new LineStartShred());
    }

    private void moveLineBreakInFrontOfBeginnings() {
        int beginningIndex;
        LineStartShred lineBeginShred = (LineStartShred)this.removeLastShred();
        LineEndShred lineEndShred = (LineEndShred)this.removeLastShred();
        for (beginningIndex = this.shreds.size(); beginningIndex > 1 && this.shreds.get(beginningIndex - 1).isDelimiterBeginning(); --beginningIndex) {
        }
        if (!this.shreds.get(beginningIndex - 1).isLineBeginning()) {
            this.shreds.add(beginningIndex, lineBeginShred);
            this.shreds.add(beginningIndex, lineEndShred);
        } else if (beginningIndex > 1) {
            LineEndShred previousLineEndShred = (LineEndShred)this.shreds.get(beginningIndex - 2);
            previousLineEndShred.appendLineBreak(lineEndShred.isHard());
        }
    }

    private void unprepareLine() {
        if (!this.isEmpty() && !this.pendingLineBreak) {
            this.pendingLineBreak = true;
            this.unbeginNewLine();
        }
    }

    private void unbeginNewLine() {
        if (!this.isEmpty()) {
            this.removeLastShred();
        }
    }

    private Shred lastShred() {
        return this.shreds.get(this.shreds.size() - 1);
    }

    private Shred removeLastShred() {
        return this.shreds.remove(this.shreds.size() - 1);
    }

    private boolean isEmpty() {
        return 1 == this.shreds.size();
    }

    public void appendTo(LineAppendable appendable) {
        if (this.isEmpty()) {
            appendable.append(this.emptyParagraphString);
        } else {
            this.ensureLastShredIsASoftLineBreak();
            this.shiftLeadingSpaceToTheLeftAndSetLeadingHints();
            this.shiftTrailingSpaceToTheRightAndSetTrailingHints();
            for (Shred shred : this.shreds) {
                shred.appendTo(appendable);
            }
        }
    }

    private void ensureLastShredIsASoftLineBreak() {
        if (this.lastShred().isLineEnding()) {
            this.removeLastShred();
        }
        this.appendLineBreak(false);
    }

    private void shiftLeadingSpaceToTheLeftAndSetLeadingHints() {
        ListIterator<Shred> iterator = this.shreds.listIterator(0);
        Shred previousShred = null;
        Shred trailingSpaceConsumer = null;
        while (iterator.hasNext()) {
            Shred currentShred = iterator.next();
            if (null != previousShred) {
                currentShred.setHint(Position.LEADING, previousShred.getType());
            }
            if (currentShred.hasSpace(Position.LEADING) && null != trailingSpaceConsumer) {
                trailingSpaceConsumer.setSpace(Position.TRAILING, true);
                currentShred.setSpace(Position.LEADING, false);
            }
            if (currentShred.consumesSpace(Position.TRAILING)) {
                trailingSpaceConsumer = currentShred;
            }
            if (currentShred.blocksSpace(Position.LEADING)) {
                trailingSpaceConsumer = null;
            }
            previousShred = currentShred;
        }
    }

    private void shiftTrailingSpaceToTheRightAndSetTrailingHints() {
        ListIterator<Shred> iterator = this.shreds.listIterator(this.shreds.size());
        Shred previousShred = null;
        Shred leadingSpaceConsumer = null;
        while (iterator.hasPrevious()) {
            Shred currentShred = iterator.previous();
            if (null != previousShred) {
                currentShred.setHint(Position.TRAILING, previousShred.getType());
            }
            if (currentShred.hasSpace(Position.TRAILING) && null != leadingSpaceConsumer) {
                leadingSpaceConsumer.setSpace(Position.LEADING, true);
                currentShred.setSpace(Position.TRAILING, false);
            }
            if (currentShred.consumesSpace(Position.LEADING)) {
                leadingSpaceConsumer = currentShred;
            }
            if (currentShred.blocksSpace(Position.TRAILING)) {
                leadingSpaceConsumer = null;
            }
            previousShred = currentShred;
        }
    }
}

