/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomHandler;
import io.markdom.handler.text.commonmark.CodeBlockOption;
import io.markdom.handler.text.commonmark.CommentBlockSection;
import io.markdom.handler.text.commonmark.CommonmarkTextConfiguration;
import io.markdom.handler.text.commonmark.ContentBuffer;
import io.markdom.handler.text.commonmark.ContentSection;
import io.markdom.handler.text.commonmark.DivisionBlockSection;
import io.markdom.handler.text.commonmark.EmptySection;
import io.markdom.handler.text.commonmark.FencedCodeBlockSection;
import io.markdom.handler.text.commonmark.HeadingBlockSection;
import io.markdom.handler.text.commonmark.IndentationStack;
import io.markdom.handler.text.commonmark.IndentedCodeBlockSection;
import io.markdom.handler.text.commonmark.IndentingAppendable;
import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.OrderedListIndentation;
import io.markdom.handler.text.commonmark.ParagraphSection;
import io.markdom.handler.text.commonmark.QuoteIndentation;
import io.markdom.handler.text.commonmark.Section;
import io.markdom.handler.text.commonmark.UnorderedListIndentation;
import io.markdom.util.ObjectHelper;
import java.util.Optional;

public final class CommonmarkTextMarkdomHandler<ActualAppendable extends Appendable>
implements MarkdomHandler<ActualAppendable> {
    private static final EmptySection EMPTY_SECTION = new EmptySection();
    private final CommonmarkTextConfiguration configuration;
    private final ActualAppendable appendable;
    private final IndentationStack indentationStack;
    private final LineAppendable lineAppendable;
    private boolean emptyBlocks;
    private MarkdomBlockType lastType;
    private MarkdomBlockType lastListBlockType;
    private boolean firstBlockInListItem;
    private int listDepth;
    private ContentBuffer buffer;
    private Section section;

    public CommonmarkTextMarkdomHandler(ActualAppendable appendable) {
        this(CommonmarkTextConfiguration.builder().build(), appendable);
    }

    public CommonmarkTextMarkdomHandler(CommonmarkTextConfiguration configuration, ActualAppendable appendable) {
        this.configuration = (CommonmarkTextConfiguration)ObjectHelper.notNull((String)"configuration", (Object)configuration);
        this.appendable = (Appendable)ObjectHelper.notNull((String)"appendable", appendable);
        this.indentationStack = new IndentationStack();
        this.lineAppendable = new IndentingAppendable(configuration, this.indentationStack, (Appendable)appendable);
    }

    public void onDocumentBegin() {
    }

    public void onBlocksBegin() {
        this.emptyBlocks = true;
    }

    public void onBlockBegin(MarkdomBlockType type) {
        this.emptyBlocks = false;
        if (null != this.lastType) {
            EMPTY_SECTION.appendTo(this.lineAppendable);
            if (this.isCodeBlock(type) && this.isCodeBlock(this.lastType) && CodeBlockOption.INDENTED == this.configuration.getCodeBlockOption()) {
                new CommentBlockSection(this.configuration.getAdjacentIndentedCodeBlockComment()).appendTo(this.lineAppendable);
                EMPTY_SECTION.appendTo(this.lineAppendable);
            }
            if (this.isListBlock(type) && this.isListBlock(this.lastType)) {
                new CommentBlockSection(this.configuration.getAdjacentListBlocksComment()).appendTo(this.lineAppendable);
                EMPTY_SECTION.appendTo(this.lineAppendable);
            }
        }
        if (this.hasLeadingDivisionInListItemConflict(type)) {
            new CommentBlockSection(this.configuration.getLeadingDivisionInListItemComment()).appendTo(this.lineAppendable);
            EMPTY_SECTION.appendTo(this.lineAppendable);
        }
    }

    private boolean isCodeBlock(MarkdomBlockType type) {
        return MarkdomBlockType.CODE == type;
    }

    private boolean isListBlock(MarkdomBlockType type) {
        return MarkdomBlockType.ORDERED_LIST == type || MarkdomBlockType.UNORDERED_LIST == type;
    }

    public void onCodeBlock(String code, Optional<String> hint) {
        switch (this.configuration.getCodeBlockOption()) {
            case FENCED: {
                this.beginSection(new FencedCodeBlockSection(this.configuration, code, hint));
                break;
            }
            case INDENTED: {
                this.beginSection(new IndentedCodeBlockSection(this.configuration, code));
            }
        }
        this.endSection(false);
    }

    private boolean hasLeadingDivisionInListItemConflict(MarkdomBlockType type) {
        return this.firstBlockInListItem && MarkdomBlockType.DIVISION == type && MarkdomBlockType.UNORDERED_LIST == this.lastListBlockType && this.configuration.getUnorderedListOption().getBulletCharacter() == this.configuration.getDivisionOption().getDivisionCharacter();
    }

    public void onCommentBlock(String comment) {
        this.section = new CommentBlockSection(comment);
        this.endSection(false);
    }

    public void onDivisionBlock() {
        this.beginSection(new DivisionBlockSection(this.configuration));
        this.endSection(false);
    }

    public void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        this.beginContentSection(new HeadingBlockSection(this.configuration, level));
    }

    public void onHeadingBlockEnd(MarkdomHeadingLevel level) {
        this.endSection(false);
    }

    public void onOrderedListBlockBegin(Integer startIndex) {
        this.lastListBlockType = MarkdomBlockType.ORDERED_LIST;
        this.indentationStack.push(new OrderedListIndentation(this.configuration, startIndex));
    }

    public void onOrderedListBlockEnd(Integer startIndex) {
        this.indentationStack.pop();
    }

    public void onParagraphBlockBegin() {
        this.beginContentSection(new ParagraphSection(this.configuration));
    }

    public void onParagraphBlockEnd() {
        this.endSection(false);
    }

    public void onQuoteBlockBegin() {
        this.indentationStack.push(new QuoteIndentation());
        this.lastType = null;
    }

    public void onQuoteBlockEnd() {
        this.indentationStack.pop();
    }

    public void onUnorderedListBlockBegin() {
        this.lastListBlockType = MarkdomBlockType.UNORDERED_LIST;
        this.indentationStack.push(new UnorderedListIndentation(this.configuration));
    }

    public void onUnorderedListBlockEnd() {
        this.indentationStack.pop();
    }

    public void onBlockEnd(MarkdomBlockType type) {
        this.firstBlockInListItem = false;
        this.lastType = type;
    }

    public void onNextBlock() {
    }

    public void onBlocksEnd() {
        if (this.emptyBlocks) {
            if (0 != this.listDepth) {
                new CommentBlockSection(this.configuration.getEmptyListItemComment()).appendTo(this.lineAppendable);
            } else {
                EMPTY_SECTION.appendTo(this.lineAppendable);
            }
        }
    }

    public void onListItemsBegin() {
        ++this.listDepth;
    }

    public void onListItemBegin() {
        this.firstBlockInListItem = true;
        this.lastType = null;
    }

    public void onListItemEnd() {
        this.indentationStack.advance();
    }

    public void onNextListItem() {
    }

    public void onListItemsEnd() {
        --this.listDepth;
    }

    public void onContentsBegin() {
    }

    public void onContentBegin(MarkdomContentType type) {
    }

    public void onCodeContent(String code) {
        this.buffer.appendCode(code);
    }

    public void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        this.buffer.appendEmphasisBegin(level);
    }

    public void onEmphasisContentEnd(MarkdomEmphasisLevel level) {
        this.buffer.appendEmphasisEnd(level);
    }

    public void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        this.buffer.appendImage(uri, title, alternative);
    }

    public void onLineBreakContent(Boolean hard) {
        this.buffer.appendLineBreak(hard);
    }

    public void onLinkContentBegin(String uri, Optional<String> title) {
        this.buffer.appendLinkBegin(uri);
    }

    public void onLinkContentEnd(String uri, Optional<String> title) {
        this.buffer.appendLinkEnd(uri, title);
    }

    public void onTextContent(String text) {
        this.buffer.appendText(text);
    }

    public void onContentEnd(MarkdomContentType type) {
    }

    public void onNextContent() {
    }

    public void onContentsEnd() {
    }

    public void onDocumentEnd() {
    }

    public ActualAppendable getResult() {
        return this.appendable;
    }

    private void beginContentSection(ContentSection section) {
        this.buffer = section.getBuffer();
        this.beginSection(section);
    }

    private void beginSection(Section section) {
        this.section = section;
    }

    private void endSection(boolean listBlock) {
        this.section.appendTo(this.lineAppendable);
    }
}

