/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.Section;
import io.markdom.util.StringUtil;
import java.util.List;

final class CommentBlockSection
implements Section {
    private final String comment;

    CommentBlockSection(String comment) {
        this.comment = comment;
    }

    @Override
    public void appendTo(LineAppendable appendable) {
        List lines = StringUtil.splitLines((String)this.comment);
        if (lines.isEmpty()) {
            appendable.startLine();
            appendable.append("<!-- -->");
            appendable.endLine();
        } else if (1 == lines.size()) {
            appendable.startLine();
            appendable.append("<!-- ");
            appendable.append((CharSequence)lines.get(0));
            appendable.append(" -->");
            appendable.endLine();
        } else {
            appendable.startLine();
            appendable.append("<!--");
            appendable.endLine();
            for (String line : lines) {
                appendable.startLine();
                appendable.append("  ");
                appendable.append(line);
                appendable.endLine();
            }
            appendable.startLine();
            appendable.append("-->");
            appendable.endLine();
        }
    }
}

