/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.text.commonmark;

import io.markdom.handler.text.commonmark.LineAppendable;
import io.markdom.handler.text.commonmark.Position;
import io.markdom.handler.text.commonmark.Shred;
import io.markdom.handler.text.commonmark.ShredType;
import io.markdom.util.StringUtil;

final class CodeShred
implements Shred {
    private final StringBuilder buffer = new StringBuilder();
    private boolean pendingLineBreak;
    private boolean trailingSpace;

    CodeShred(String code) {
        this.appendCode(code);
    }

    @Override
    public ShredType getType() {
        return ShredType.CODE;
    }

    @Override
    public boolean appendCode(String code) {
        int n = code.length();
        block5: for (int i = 0; i < n; ++i) {
            char character = code.charAt(i);
            switch (character) {
                case '\r': {
                    continue block5;
                }
                case '\n': {
                    if (this.isEmpty()) continue block5;
                    this.pendingLineBreak = true;
                    continue block5;
                }
                case '\t': 
                case ' ': {
                    if (this.pendingLineBreak) {
                        if (!this.trailingSpace) {
                            this.buffer.append(' ');
                        }
                        this.pendingLineBreak = false;
                    } else {
                        this.buffer.append(' ');
                    }
                    this.trailingSpace = true;
                    continue block5;
                }
                default: {
                    if (this.pendingLineBreak) {
                        if (!this.trailingSpace) {
                            this.buffer.append(' ');
                        }
                        this.pendingLineBreak = false;
                    }
                    this.buffer.append(character);
                    this.trailingSpace = false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean blocksSpace(Position position) {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.buffer.length();
    }

    @Override
    public void appendTo(LineAppendable appendable) {
        int fenceLength = Math.max(1, StringUtil.longestSequenceLength((CharSequence)this.buffer, (char)'`') + 1);
        String fence = StringUtil.repeat((char)'`', (int)fenceLength);
        appendable.append(fence);
        boolean needsExtraSpace = this.needsExtraSpace();
        if (needsExtraSpace) {
            appendable.append(" ");
        }
        appendable.append(this.buffer);
        if (needsExtraSpace) {
            appendable.append(" ");
        }
        appendable.append(fence);
    }

    private boolean needsExtraSpace() {
        char firstCharacter = this.buffer.charAt(0);
        char lastCharacter = this.buffer.charAt(this.buffer.length() - 1);
        boolean onlySpaces = StringUtil.consistsOnlyOf((CharSequence)this.buffer, (char)' ');
        return !onlySpaces && (this.needsExtraSpace(firstCharacter) || this.needsExtraSpace(lastCharacter));
    }

    private boolean needsExtraSpace(char character) {
        return '`' == character || ' ' == character;
    }

    public String toString() {
        return "(`" + this.buffer + "`)";
    }
}

