/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.html.w3c;

import io.markdom.handler.html.AbstractHtmlDocumentMarkdomHandler;
import io.markdom.handler.html.DefaultHtmlDelegate;
import io.markdom.handler.html.HtmlDelegate;
import io.markdom.handler.html.w3c.XhtmlDocumentResult;
import io.markdom.util.Attribute;
import io.markdom.util.Attributes;
import io.markdom.util.ObjectHelper;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class XhtmlDocumentMarkdomHandler
extends AbstractHtmlDocumentMarkdomHandler<XhtmlDocumentResult> {
    private static final DefaultHtmlDelegate DEFAULT_DELEGATE = new DefaultHtmlDelegate();
    private static final String DEFAULT_TITLE = "Markdom";
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static final String LEGACY_SYSTEM_ID = "about:legacy-compat";
    private final DocumentBuilder builder;
    private Document document;
    private Element element;

    public XhtmlDocumentMarkdomHandler(DocumentBuilder builder) {
        this(builder, (HtmlDelegate)DEFAULT_DELEGATE, DEFAULT_TITLE);
    }

    public XhtmlDocumentMarkdomHandler(DocumentBuilder builder, String title) {
        this(builder, (HtmlDelegate)DEFAULT_DELEGATE, title);
    }

    public XhtmlDocumentMarkdomHandler(DocumentBuilder builder, HtmlDelegate delegate) {
        this(builder, delegate, DEFAULT_TITLE);
    }

    public XhtmlDocumentMarkdomHandler(DocumentBuilder builder, HtmlDelegate delegate, String title) {
        super(delegate, title);
        this.builder = (DocumentBuilder)ObjectHelper.notNull((String)"builder", (Object)builder);
    }

    protected final void beginDocument(String dtdQualifiedName, String rootTagName) {
        DOMImplementation domImplementation = this.builder.getDOMImplementation();
        DocumentType doctype = domImplementation.createDocumentType(dtdQualifiedName, "", LEGACY_SYSTEM_ID);
        this.document = domImplementation.createDocument(XMLNS_NAMESPACE, rootTagName, doctype);
        this.element = this.document.getDocumentElement();
    }

    protected final void pushElement(String tagName) {
        Element element = this.document.createElement(tagName);
        this.element.appendChild(element);
        this.element = element;
    }

    protected final void setAttributes(Attributes attributes) {
        for (Attribute attribute : attributes) {
            this.element.setAttribute(attribute.getKey(), attribute.getValue());
        }
    }

    protected final void setText(String text) {
        Text textNode = this.document.createTextNode(text);
        this.element.appendChild(textNode);
    }

    protected final void setCharacterData(String text) {
        CDATASection characterNode = this.document.createCDATASection(text);
        this.element.appendChild(characterNode);
    }

    protected final void popElement() {
        this.element = (Element)this.element.getParentNode();
    }

    protected void endDocument() {
    }

    public XhtmlDocumentResult getResult() {
        return new XhtmlDocumentResult(this.builder, this.document);
    }
}

