/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.html.w3c;

import io.markdom.handler.html.HtmlDocumentResult;
import io.markdom.util.Attribute;
import io.markdom.util.Attributes;
import io.markdom.util.ObjectHelper;
import io.markdom.util.XmlHelper;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import net.markenwerk.commons.iterables.NodeListIterable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XhtmlDocumentResult
implements HtmlDocumentResult<Document, Element, NodeList> {
    private final DocumentBuilder builder;
    private final Document document;

    public XhtmlDocumentResult(DocumentBuilder builder, Document document) {
        this.builder = (DocumentBuilder)ObjectHelper.notNull((String)"builder", (Object)builder);
        this.document = (Document)ObjectHelper.notNull((String)"document", (Object)document);
    }

    public Document asDocument() {
        return (Document)this.document.cloneNode(true);
    }

    public String asDocumentText(boolean pretty) {
        if (pretty) {
            return XmlHelper.asText((Node)this.asDocument(), (boolean)true);
        }
        return XmlHelper.asText((Node)this.asDocument(), (boolean)false).replaceFirst(Pattern.quote("\n"), "");
    }

    public Element asElement(String tagName, Attributes attributes) {
        Document document = this.builder.newDocument();
        Element element = document.createElement(tagName);
        for (Attribute attribute : attributes) {
            element.setAttribute(attribute.getKey(), attribute.getValue());
        }
        for (Node node : new NodeListIterable(this.asElements())) {
            element.appendChild(document.importNode(node, true));
        }
        return element;
    }

    public String asElementText(String tagName, Attributes attributes, boolean pretty) {
        return XmlHelper.asText((Node)this.asElement(tagName, attributes), (boolean)pretty);
    }

    public NodeList asElements() {
        return ((Element)((Object)this.asDocument().getLastChild().getChildNodes())).getLastChild().getChildNodes();
    }

    public String asElementsText(boolean pretty) {
        StringBuilder builder = new StringBuilder();
        for (Node node : new NodeListIterable(this.asElements())) {
            builder.append(XmlHelper.asText((Node)node, (boolean)pretty));
        }
        return builder.toString();
    }
}

