/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.html.jsoup;

import io.markdom.handler.html.HtmlDocumentResult;
import io.markdom.util.Attribute;
import io.markdom.util.Attributes;
import io.markdom.util.ObjectHelper;
import java.util.Iterator;
import java.util.List;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public final class JsoupHtmlDocumentResult
implements HtmlDocumentResult<Document, Element, List<Node>> {
    private final Document document;

    public JsoupHtmlDocumentResult(Document document) {
        this.document = (Document)ObjectHelper.notNull((String)"document", (Object)document);
    }

    public Document asDocument() {
        return this.document.clone();
    }

    public String asDocumentText(boolean pretty) {
        this.document.outputSettings().prettyPrint(pretty);
        return this.asDocument().outerHtml();
    }

    public Element asElement(String tagName, Attributes attributes) {
        Document document = new Document(this.document.baseUri());
        Element element = document.createElement(tagName);
        document.appendChild((Node)element);
        for (Attribute attribute : attributes) {
            element.attr(attribute.getKey(), attribute.getValue());
        }
        Iterator iterator = this.asNodes().iterator();
        while (iterator.hasNext()) {
            Node blockNode = (Node)iterator.next();
            element.appendChild(blockNode.clone());
        }
        return element;
    }

    public String asElementText(String tagName, Attributes attributes, boolean pretty) {
        Element element = this.asElement(tagName, attributes);
        element.ownerDocument().outputSettings().prettyPrint(pretty);
        return element.outerHtml();
    }

    public List<Node> asNodes() {
        return this.asDocument().body().childNodes();
    }

    public String asNodesText(boolean pretty) {
        StringBuilder builder = new StringBuilder();
        Iterator iterator = this.asNodes().iterator();
        if (iterator.hasNext()) {
            this.append(builder, (Node)iterator.next(), pretty);
            while (iterator.hasNext()) {
                if (pretty) {
                    builder.append("\n");
                }
                this.append(builder, (Node)iterator.next(), pretty);
            }
        }
        return builder.toString();
    }

    private void append(StringBuilder builder, Node blockNode, boolean pretty) {
        blockNode.ownerDocument().outputSettings().prettyPrint(pretty);
        builder.append(blockNode.outerHtml());
    }
}

