/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.html.jsoup;

import io.markdom.handler.html.AbstractHtmlDocumentMarkdomHandler;
import io.markdom.handler.html.DefaultHtmlDelegate;
import io.markdom.handler.html.HtmlDelegate;
import io.markdom.handler.html.jsoup.JsoupHtmlDocumentResult;
import io.markdom.util.Attribute;
import io.markdom.util.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public final class JsoupHtmlDocumentMarkdomHandler
extends AbstractHtmlDocumentMarkdomHandler<JsoupHtmlDocumentResult> {
    private static final DefaultHtmlDelegate DEFAULT_DELEGATE = new DefaultHtmlDelegate();
    private static final String DEFAULT_TITLE = "Markdom";
    private Document document;
    private Element element;

    public JsoupHtmlDocumentMarkdomHandler() {
        this((HtmlDelegate)DEFAULT_DELEGATE, DEFAULT_TITLE);
    }

    public JsoupHtmlDocumentMarkdomHandler(String title) {
        this((HtmlDelegate)DEFAULT_DELEGATE, title);
    }

    public JsoupHtmlDocumentMarkdomHandler(HtmlDelegate delegate) {
        this(delegate, DEFAULT_TITLE);
    }

    public JsoupHtmlDocumentMarkdomHandler(HtmlDelegate delegate, String title) {
        super(delegate, title);
    }

    protected final void beginDocument(String dtdQualifiedName, String rootTagName) {
        this.document = new Document("");
        this.document.appendChild((Node)new DocumentType(dtdQualifiedName, "", ""));
        this.element = this.document;
        this.pushElement(rootTagName);
    }

    protected final void pushElement(String tagName) {
        Element element = this.document.createElement(tagName);
        this.element.appendChild((Node)element);
        this.element = element;
    }

    protected final void setAttributes(Attributes attributes) {
        for (Attribute attribute : attributes) {
            this.element.attr(attribute.getKey(), attribute.getValue());
        }
    }

    protected final void setText(String text) {
        this.element.appendText(text);
    }

    protected void setCharacterData(String text) {
        this.element.appendText(text);
    }

    protected final void popElement() {
        this.element = this.element.parent();
    }

    protected void endDocument() {
        this.popElement();
    }

    public JsoupHtmlDocumentResult getResult() {
        return new JsoupHtmlDocumentResult(this.document);
    }
}

