/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.json;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomException;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomDispatcher;
import io.markdom.handler.MarkdomHandler;
import io.markdom.handler.SimpleMarkdomHandler;
import io.markdom.util.ObjectHelper;
import java.util.Iterator;
import java.util.Optional;

public abstract class AbstractJsonObjectMarkdomDispatcher<JsonObject, JsonArray>
implements MarkdomDispatcher {
    private SimpleMarkdomHandler<?> handler;

    @Override
    public final <Result> Result handle(MarkdomHandler<Result> handler) {
        this.handler = new SimpleMarkdomHandler((MarkdomHandler)ObjectHelper.notNull((String)"handler", handler));
        try {
            JsonObject documentObject = this.getRootObject();
            this.checkVersion(this.reqString(documentObject, "version"));
            this.document(documentObject);
            return handler.getResult();
        }
        catch (Exception e) {
            throw new MarkdomException(e);
        }
    }

    private void checkVersion(String version) {
        if (!"1.0".equals(version)) {
            throw new MarkdomException("Unsupported major version: " + version);
        }
    }

    private void document(JsonObject documentObject) {
        this.handler.onDocumentBegin();
        this.blocks(this.optArray(documentObject, "blocks"));
        this.handler.onDocumentEnd();
    }

    private void blocks(JsonArray blocksArray) {
        this.getObjects(blocksArray).forEachRemaining(this::block);
    }

    private void block(JsonObject blockObject) {
        MarkdomBlockType type = MarkdomBlockType.fromName(this.reqString(blockObject, "type"));
        switch (type) {
            case CODE: {
                this.codeBlock(blockObject);
                return;
            }
            case COMMENT: {
                this.commentBlock(blockObject);
                return;
            }
            case DIVISION: {
                this.divisionBlock(blockObject);
                return;
            }
            case HEADING: {
                this.headingBlock(blockObject);
                return;
            }
            case ORDERED_LIST: {
                this.orderedListBlock(blockObject);
                return;
            }
            case PARAGRAPH: {
                this.paragraphBlock(blockObject);
                return;
            }
            case QUOTE: {
                this.quoteBlock(blockObject);
                return;
            }
            case UNORDERED_LIST: {
                this.unorderedListBlock(blockObject);
                return;
            }
        }
        throw new InternalError("Unexpected block type: " + (Object)((Object)type));
    }

    private void codeBlock(JsonObject codeObject) {
        String code = this.reqString(codeObject, "code");
        Optional<String> hint = this.optString(codeObject, "hint");
        this.handler.onCodeBlock(code, hint);
    }

    private void commentBlock(JsonObject commentObject) {
        String comment = this.reqString(commentObject, "comment");
        this.handler.onCommentBlock(comment);
    }

    private void divisionBlock(JsonObject divisionObject) {
        this.handler.onDivisionBlock();
    }

    private void headingBlock(JsonObject headingObject) {
        MarkdomHeadingLevel level = MarkdomHeadingLevel.values()[this.reqInteger(headingObject, "level") - 1];
        this.handler.onHeadingBlockBegin(level);
        this.contents(this.optArray(headingObject, "contents"));
        this.handler.onHeadingBlockEnd();
    }

    private void orderedListBlock(JsonObject orderedListObject) {
        int startIndex = this.reqInteger(orderedListObject, "startIndex");
        this.handler.onOrderedListBlockBegin(startIndex);
        this.items(this.optArray(orderedListObject, "items"));
        this.handler.onOrderedListBlockEnd();
    }

    private void paragraphBlock(JsonObject paragraphObject) {
        this.handler.onParagraphBlockBegin();
        this.contents(this.optArray(paragraphObject, "contents"));
        this.handler.onParagraphBlockEnd();
    }

    private void quoteBlock(JsonObject quoteObject) {
        this.handler.onQuoteBlockBegin();
        this.blocks(this.optArray(quoteObject, "blocks"));
        this.handler.onQuoteBlockEnd();
    }

    private void unorderedListBlock(JsonObject unorderedListObject) {
        this.handler.onUnorderedListBlockBegin();
        this.items(this.optArray(unorderedListObject, "items"));
        this.handler.onUnorderedListBlockEnd();
    }

    private void items(JsonArray itemsArray) {
        this.getObjects(itemsArray).forEachRemaining(this::item);
    }

    private void item(JsonObject itemObject) {
        this.handler.onListItemBegin();
        this.blocks(this.optArray(itemObject, "blocks"));
        this.handler.onListItemEnd();
    }

    private void contents(JsonArray contentsArray) {
        this.getObjects(contentsArray).forEachRemaining(this::content);
    }

    private void content(JsonObject contentObject) {
        MarkdomContentType type = MarkdomContentType.fromName(this.reqString(contentObject, "type"));
        switch (type) {
            case CODE: {
                this.codeContent(contentObject);
                return;
            }
            case EMPHASIS: {
                this.emphasisContent(contentObject);
                return;
            }
            case IMAGE: {
                this.imageContent(contentObject);
                return;
            }
            case LINE_BREAK: {
                this.lineBreakContent(contentObject);
                return;
            }
            case LINK: {
                this.linkContent(contentObject);
                return;
            }
            case TEXT: {
                this.textContent(contentObject);
                return;
            }
        }
        throw new InternalError("Unexpected content type: " + (Object)((Object)type));
    }

    private void codeContent(JsonObject codeObject) {
        String code = this.reqString(codeObject, "code");
        this.handler.onCodeContent(code);
    }

    private void emphasisContent(JsonObject emphasisObject) {
        MarkdomEmphasisLevel level = MarkdomEmphasisLevel.values()[this.reqInteger(emphasisObject, "level") - 1];
        this.handler.onEmphasisContentBegin(level);
        this.contents(this.optArray(emphasisObject, "contents"));
        this.handler.onEmphasisContentEnd();
    }

    private void imageContent(JsonObject imageObject) {
        String uri = this.reqString(imageObject, "uri");
        Optional<String> title = this.optString(imageObject, "title");
        Optional<String> alternative = this.optString(imageObject, "alternative");
        this.handler.onImageContent(uri, title, alternative);
    }

    private void lineBreakContent(JsonObject lineBreakObject) {
        boolean hard = this.reqBoolean(lineBreakObject, "hard");
        this.handler.onLineBreakContent(hard);
    }

    private void linkContent(JsonObject linkObject) {
        String uri = this.reqString(linkObject, "uri");
        Optional<String> title = this.optString(linkObject, "title");
        this.handler.onLinkContentBegin(uri, title);
        this.contents(this.optArray(linkObject, "contents"));
        this.handler.onLinkContentEnd();
    }

    private void textContent(JsonObject textObject) {
        String text = this.reqString(textObject, "text");
        this.handler.onTextContent(text);
    }

    protected abstract JsonObject getRootObject();

    protected abstract Iterator<JsonObject> getObjects(JsonArray var1);

    protected abstract JsonArray optArray(JsonObject var1, String var2);

    protected abstract Optional<String> optString(JsonObject var1, String var2);

    protected abstract String reqString(JsonObject var1, String var2);

    protected abstract Boolean reqBoolean(JsonObject var1, String var2);

    protected abstract Integer reqInteger(JsonObject var1, String var2);
}

