/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomHandler;
import io.markdom.model.MarkdomBlockParent;
import io.markdom.model.MarkdomCodeBlock;
import io.markdom.model.MarkdomCodeContent;
import io.markdom.model.MarkdomCommentBlock;
import io.markdom.model.MarkdomContentParent;
import io.markdom.model.MarkdomDocument;
import io.markdom.model.MarkdomEmphasisContent;
import io.markdom.model.MarkdomFactory;
import io.markdom.model.MarkdomHeadingBlock;
import io.markdom.model.MarkdomImageContent;
import io.markdom.model.MarkdomLinkContent;
import io.markdom.model.MarkdomListBlock;
import io.markdom.model.MarkdomListItem;
import io.markdom.model.MarkdomOrderedListBlock;
import io.markdom.model.MarkdomParagraphBlock;
import io.markdom.model.MarkdomQuoteBlock;
import io.markdom.model.MarkdomTextContent;
import io.markdom.model.MarkdomUnorderedListBlock;
import io.markdom.util.ObjectHelper;
import java.util.Optional;
import java.util.Stack;

public final class MarkdomDocumentMarkdomHandler
implements MarkdomHandler<MarkdomDocument> {
    private final MarkdomFactory factory;
    private final MarkdomDocument document;
    private final Stack<MarkdomListBlock> listBlocks = new Stack();
    private final Stack<MarkdomBlockParent> blockParents = new Stack();
    private final Stack<MarkdomContentParent> contentParents = new Stack();

    public MarkdomDocumentMarkdomHandler(MarkdomFactory factory) {
        this.factory = (MarkdomFactory)ObjectHelper.notNull((String)"factory", (Object)factory);
        this.document = factory.document();
    }

    @Override
    public void onDocumentBegin() {
        this.blockParents.push(this.document);
    }

    @Override
    public void onBlocksBegin() {
    }

    @Override
    public void onBlockBegin(MarkdomBlockType type) {
    }

    @Override
    public void onCodeBlock(String code, Optional<String> hint) {
        MarkdomCodeBlock block = this.factory.codeBlock(code, hint);
        this.blockParents.peek().addBlock(block);
    }

    @Override
    public void onCommentBlock(String comment) {
        MarkdomCommentBlock block = this.factory.commentBlock(comment);
        this.blockParents.peek().addBlock(block);
    }

    @Override
    public void onDivisionBlock() {
        this.blockParents.peek().addBlock(this.factory.divisionBlock());
    }

    @Override
    public void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        MarkdomHeadingBlock block = this.factory.headingBlock(level);
        this.blockParents.peek().addBlock(block);
        this.contentParents.push(block);
    }

    @Override
    public void onHeadingBlockEnd(MarkdomHeadingLevel level) {
        this.contentParents.pop();
    }

    @Override
    public void onOrderedListBlockBegin(Integer startIndex) {
        MarkdomOrderedListBlock block = this.factory.orderedListBlock(startIndex);
        this.blockParents.peek().addBlock(block);
        this.listBlocks.push(block);
    }

    @Override
    public void onOrderedListBlockEnd(Integer startIndex) {
        this.listBlocks.pop();
    }

    @Override
    public void onParagraphBlockBegin() {
        MarkdomParagraphBlock block = this.factory.paragraphBlock();
        this.blockParents.peek().addBlock(block);
        this.contentParents.push(block);
    }

    @Override
    public void onParagraphBlockEnd() {
        this.contentParents.pop();
    }

    @Override
    public void onQuoteBlockBegin() {
        MarkdomQuoteBlock block = this.factory.quoteBlock();
        this.blockParents.peek().addBlock(block);
        this.blockParents.push(block);
    }

    @Override
    public void onQuoteBlockEnd() {
        this.blockParents.pop();
    }

    @Override
    public void onUnorderedListBlockBegin() {
        MarkdomUnorderedListBlock block = this.factory.unorderedListBlock();
        this.blockParents.peek().addBlock(block);
        this.listBlocks.push(block);
    }

    @Override
    public void onUnorderedListBlockEnd() {
        this.listBlocks.pop();
    }

    @Override
    public void onBlockEnd(MarkdomBlockType type) {
    }

    @Override
    public void onNextBlock() {
    }

    @Override
    public void onBlocksEnd() {
    }

    @Override
    public void onListItemsBegin() {
    }

    @Override
    public void onListItemBegin() {
        MarkdomListItem item = this.factory.listItem();
        this.listBlocks.peek().addListItem(item);
        this.blockParents.push(item);
    }

    @Override
    public void onListItemEnd() {
        this.blockParents.pop();
    }

    @Override
    public void onNextListItem() {
    }

    @Override
    public void onListItemsEnd() {
    }

    @Override
    public void onContentsBegin() {
    }

    @Override
    public void onContentBegin(MarkdomContentType type) {
    }

    @Override
    public void onCodeContent(String code) {
        MarkdomCodeContent content = this.factory.codeContent(code);
        this.contentParents.peek().addContent(content);
    }

    @Override
    public void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        MarkdomEmphasisContent content = this.factory.emphasisContent(level);
        this.contentParents.peek().addContent(content);
        this.contentParents.push(content);
    }

    @Override
    public void onEmphasisContentEnd(MarkdomEmphasisLevel level) {
        this.contentParents.pop();
    }

    @Override
    public void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        MarkdomImageContent content = this.factory.imageContent(uri, title, alternative);
        this.contentParents.peek().addContent(content);
    }

    @Override
    public void onLineBreakContent(Boolean hard) {
        this.contentParents.peek().addContent(this.factory.lineBreakContent(hard));
    }

    @Override
    public void onLinkContentBegin(String uri, Optional<String> title) {
        MarkdomLinkContent content = this.factory.linkContent(uri, title);
        this.contentParents.peek().addContent(content);
        this.contentParents.push(content);
    }

    @Override
    public void onLinkContentEnd(String uri, Optional<String> title) {
        this.contentParents.pop();
    }

    @Override
    public void onTextContent(String text) {
        MarkdomTextContent content = this.factory.textContent(text);
        this.contentParents.peek().addContent(content);
    }

    @Override
    public void onContentEnd(MarkdomContentType type) {
    }

    @Override
    public void onNextContent() {
    }

    @Override
    public void onContentsEnd() {
    }

    @Override
    public void onDocumentEnd() {
        this.blockParents.pop();
    }

    @Override
    public MarkdomDocument getResult() {
        return this.document;
    }
}

