/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.lumigo.core.utils.SecretScrubber;
import io.lumigo.core.utils.StringUtils;
import io.lumigo.models.Reportable;
import java.util.Collections;
import java.util.List;

public class HttpSpan
implements Reportable {
    private Long started;
    private Long ended;
    private String id;
    private String type;
    private String transactionId;
    private String account;
    private String region;
    private String token;
    private Info info;
    private String parentId;

    @Override
    public Reportable scrub(SecretScrubber scrubber) {
        this.getInfo().getHttpInfo().getRequest().setHeaders(scrubber.scrubStringifiedObject(this.getInfo().getHttpInfo().getRequest().getHeaders()));
        this.getInfo().getHttpInfo().getRequest().setBody(scrubber.scrubStringifiedObject(this.getInfo().getHttpInfo().getRequest().getBody()));
        this.getInfo().getHttpInfo().getResponse().setHeaders(scrubber.scrubStringifiedObject(this.getInfo().getHttpInfo().getResponse().getHeaders()));
        this.getInfo().getHttpInfo().getResponse().setBody(scrubber.scrubStringifiedObject(this.getInfo().getHttpInfo().getResponse().getBody()));
        return this;
    }

    @Override
    public Reportable reduceSize(int maxFieldSize) {
        this.getInfo().getHttpInfo().getRequest().setHeaders(StringUtils.getMaxSizeString(this.getInfo().getHttpInfo().getRequest().getHeaders(), maxFieldSize));
        this.getInfo().getHttpInfo().getRequest().setBody(StringUtils.getMaxSizeString(this.getInfo().getHttpInfo().getRequest().getBody(), maxFieldSize));
        this.getInfo().getHttpInfo().getResponse().setHeaders(StringUtils.getMaxSizeString(this.getInfo().getHttpInfo().getResponse().getHeaders(), maxFieldSize));
        this.getInfo().getHttpInfo().getResponse().setBody(StringUtils.getMaxSizeString(this.getInfo().getHttpInfo().getResponse().getBody(), maxFieldSize));
        return this;
    }

    public static HttpSpanBuilder builder() {
        return new HttpSpanBuilder();
    }

    public HttpSpanBuilder toBuilder() {
        return new HttpSpanBuilder().started(this.started).ended(this.ended).id(this.id).type(this.type).transactionId(this.transactionId).account(this.account).region(this.region).token(this.token).info(this.info).parentId(this.parentId);
    }

    public HttpSpan(Long started, Long ended, String id, String type, String transactionId, String account, String region, String token, Info info, String parentId) {
        this.started = started;
        this.ended = ended;
        this.id = id;
        this.type = type;
        this.transactionId = transactionId;
        this.account = account;
        this.region = region;
        this.token = token;
        this.info = info;
        this.parentId = parentId;
    }

    public Long getStarted() {
        return this.started;
    }

    public Long getEnded() {
        return this.ended;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getAccount() {
        return this.account;
    }

    public String getRegion() {
        return this.region;
    }

    public String getToken() {
        return this.token;
    }

    public Info getInfo() {
        return this.info;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setStarted(Long started) {
        this.started = started;
    }

    public void setEnded(Long ended) {
        this.ended = ended;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpSpan)) {
            return false;
        }
        HttpSpan other = (HttpSpan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$started = this.getStarted();
        Long other$started = other.getStarted();
        if (this$started == null ? other$started != null : !((Object)this$started).equals(other$started)) {
            return false;
        }
        Long this$ended = this.getEnded();
        Long other$ended = other.getEnded();
        if (this$ended == null ? other$ended != null : !((Object)this$ended).equals(other$ended)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Info this$info = this.getInfo();
        Info other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        return !(this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpSpan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $started = this.getStarted();
        result = result * 59 + ($started == null ? 43 : ((Object)$started).hashCode());
        Long $ended = this.getEnded();
        result = result * 59 + ($ended == null ? 43 : ((Object)$ended).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Info $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        return result;
    }

    public String toString() {
        return "HttpSpan(started=" + this.getStarted() + ", ended=" + this.getEnded() + ", id=" + this.getId() + ", type=" + this.getType() + ", transactionId=" + this.getTransactionId() + ", account=" + this.getAccount() + ", region=" + this.getRegion() + ", token=" + this.getToken() + ", info=" + this.getInfo() + ", parentId=" + this.getParentId() + ")";
    }

    public static class HttpSpanBuilder {
        private Long started;
        private Long ended;
        private String id;
        private String type;
        private String transactionId;
        private String account;
        private String region;
        private String token;
        private Info info;
        private String parentId;

        HttpSpanBuilder() {
        }

        public HttpSpanBuilder started(Long started) {
            this.started = started;
            return this;
        }

        public HttpSpanBuilder ended(Long ended) {
            this.ended = ended;
            return this;
        }

        public HttpSpanBuilder id(String id) {
            this.id = id;
            return this;
        }

        public HttpSpanBuilder type(String type) {
            this.type = type;
            return this;
        }

        public HttpSpanBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public HttpSpanBuilder account(String account) {
            this.account = account;
            return this;
        }

        public HttpSpanBuilder region(String region) {
            this.region = region;
            return this;
        }

        public HttpSpanBuilder token(String token) {
            this.token = token;
            return this;
        }

        public HttpSpanBuilder info(Info info) {
            this.info = info;
            return this;
        }

        public HttpSpanBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public HttpSpan build() {
            return new HttpSpan(this.started, this.ended, this.id, this.type, this.transactionId, this.account, this.region, this.token, this.info, this.parentId);
        }

        public String toString() {
            return "HttpSpan.HttpSpanBuilder(started=" + this.started + ", ended=" + this.ended + ", id=" + this.id + ", type=" + this.type + ", transactionId=" + this.transactionId + ", account=" + this.account + ", region=" + this.region + ", token=" + this.token + ", info=" + this.info + ", parentId=" + this.parentId + ")";
        }
    }

    public static class HttpData {
        private String headers;
        private String body;
        private String uri;
        private Integer statusCode;
        private String method;

        public static HttpDataBuilder builder() {
            return new HttpDataBuilder();
        }

        public HttpDataBuilder toBuilder() {
            return new HttpDataBuilder().headers(this.headers).body(this.body).uri(this.uri).statusCode(this.statusCode).method(this.method);
        }

        public HttpData(String headers, String body, String uri, Integer statusCode, String method) {
            this.headers = headers;
            this.body = body;
            this.uri = uri;
            this.statusCode = statusCode;
            this.method = method;
        }

        public String getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }

        public String getUri() {
            return this.uri;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public String getMethod() {
            return this.method;
        }

        public void setHeaders(String headers) {
            this.headers = headers;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpData)) {
                return false;
            }
            HttpData other = (HttpData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$statusCode = this.getStatusCode();
            Integer other$statusCode = other.getStatusCode();
            if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
                return false;
            }
            String this$headers = this.getHeaders();
            String other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !this$method.equals(other$method));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $statusCode = this.getStatusCode();
            result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
            String $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            return result;
        }

        public String toString() {
            return "HttpSpan.HttpData(headers=" + this.getHeaders() + ", body=" + this.getBody() + ", uri=" + this.getUri() + ", statusCode=" + this.getStatusCode() + ", method=" + this.getMethod() + ")";
        }

        public static class HttpDataBuilder {
            private String headers;
            private String body;
            private String uri;
            private Integer statusCode;
            private String method;

            HttpDataBuilder() {
            }

            public HttpDataBuilder headers(String headers) {
                this.headers = headers;
                return this;
            }

            public HttpDataBuilder body(String body) {
                this.body = body;
                return this;
            }

            public HttpDataBuilder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public HttpDataBuilder statusCode(Integer statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            public HttpDataBuilder method(String method) {
                this.method = method;
                return this;
            }

            public HttpData build() {
                return new HttpData(this.headers, this.body, this.uri, this.statusCode, this.method);
            }

            public String toString() {
                return "HttpSpan.HttpData.HttpDataBuilder(headers=" + this.headers + ", body=" + this.body + ", uri=" + this.uri + ", statusCode=" + this.statusCode + ", method=" + this.method + ")";
            }
        }
    }

    public static class HttpInfo {
        private String host;
        private HttpData request;
        private HttpData response;

        public static HttpInfoBuilder builder() {
            return new HttpInfoBuilder();
        }

        public HttpInfoBuilder toBuilder() {
            return new HttpInfoBuilder().host(this.host).request(this.request).response(this.response);
        }

        public HttpInfo(String host, HttpData request, HttpData response) {
            this.host = host;
            this.request = request;
            this.response = response;
        }

        public String getHost() {
            return this.host;
        }

        public HttpData getRequest() {
            return this.request;
        }

        public HttpData getResponse() {
            return this.response;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setRequest(HttpData request) {
            this.request = request;
        }

        public void setResponse(HttpData response) {
            this.response = response;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpInfo)) {
                return false;
            }
            HttpInfo other = (HttpInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            HttpData this$request = this.getRequest();
            HttpData other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            HttpData this$response = this.getResponse();
            HttpData other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            HttpData $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            HttpData $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            return result;
        }

        public String toString() {
            return "HttpSpan.HttpInfo(host=" + this.getHost() + ", request=" + this.getRequest() + ", response=" + this.getResponse() + ")";
        }

        public static class HttpInfoBuilder {
            private String host;
            private HttpData request;
            private HttpData response;

            HttpInfoBuilder() {
            }

            public HttpInfoBuilder host(String host) {
                this.host = host;
                return this;
            }

            public HttpInfoBuilder request(HttpData request) {
                this.request = request;
                return this;
            }

            public HttpInfoBuilder response(HttpData response) {
                this.response = response;
                return this;
            }

            public HttpInfo build() {
                return new HttpInfo(this.host, this.request, this.response);
            }

            public String toString() {
                return "HttpSpan.HttpInfo.HttpInfoBuilder(host=" + this.host + ", request=" + this.request + ", response=" + this.response + ")";
            }
        }
    }

    public static class Tracer {
        private String version;

        public static TracerBuilder builder() {
            return new TracerBuilder();
        }

        public TracerBuilder toBuilder() {
            return new TracerBuilder().version(this.version);
        }

        public Tracer(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tracer)) {
                return false;
            }
            Tracer other = (Tracer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tracer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "HttpSpan.Tracer(version=" + this.getVersion() + ")";
        }

        public static class TracerBuilder {
            private String version;

            TracerBuilder() {
            }

            public TracerBuilder version(String version) {
                this.version = version;
                return this;
            }

            public Tracer build() {
                return new Tracer(this.version);
            }

            public String toString() {
                return "HttpSpan.Tracer.TracerBuilder(version=" + this.version + ")";
            }
        }
    }

    public static class TraceId {
        @JsonProperty(value="Root")
        private String root;

        public static TraceIdBuilder builder() {
            return new TraceIdBuilder();
        }

        public TraceIdBuilder toBuilder() {
            return new TraceIdBuilder().root(this.root);
        }

        public TraceId(String root) {
            this.root = root;
        }

        public String getRoot() {
            return this.root;
        }

        @JsonProperty(value="Root")
        public void setRoot(String root) {
            this.root = root;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TraceId)) {
                return false;
            }
            TraceId other = (TraceId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$root = this.getRoot();
            String other$root = other.getRoot();
            return !(this$root == null ? other$root != null : !this$root.equals(other$root));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TraceId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $root = this.getRoot();
            result = result * 59 + ($root == null ? 43 : $root.hashCode());
            return result;
        }

        public String toString() {
            return "HttpSpan.TraceId(root=" + this.getRoot() + ")";
        }

        public static class TraceIdBuilder {
            private String root;

            TraceIdBuilder() {
            }

            @JsonProperty(value="Root")
            public TraceIdBuilder root(String root) {
                this.root = root;
                return this;
            }

            public TraceId build() {
                return new TraceId(this.root);
            }

            public String toString() {
                return "HttpSpan.TraceId.TraceIdBuilder(root=" + this.root + ")";
            }
        }
    }

    public static class Info {
        private Tracer tracer;
        private TraceId traceId;
        private HttpInfo httpInfo;
        private String messageId;
        private List<String> messageIds;
        private String resourceName;
        private String targetArn;

        public Info(Tracer tracer, TraceId traceId, HttpInfo httpInfo, String messageId, List<String> messageIds, String resourceName, String targetArn) {
            this.tracer = tracer;
            this.traceId = traceId;
            this.httpInfo = httpInfo;
            this.messageId = messageId;
            if (messageIds != null) {
                this.messageIds = Collections.unmodifiableList(messageIds);
            }
            this.resourceName = resourceName;
            this.targetArn = targetArn;
        }

        public static InfoBuilder builder() {
            return new InfoBuilder();
        }

        public InfoBuilder toBuilder() {
            return new InfoBuilder().tracer(this.tracer).traceId(this.traceId).httpInfo(this.httpInfo).messageId(this.messageId).messageIds(this.messageIds).resourceName(this.resourceName).targetArn(this.targetArn);
        }

        public Tracer getTracer() {
            return this.tracer;
        }

        public TraceId getTraceId() {
            return this.traceId;
        }

        public HttpInfo getHttpInfo() {
            return this.httpInfo;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public List<String> getMessageIds() {
            return this.messageIds;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public String getTargetArn() {
            return this.targetArn;
        }

        public void setTracer(Tracer tracer) {
            this.tracer = tracer;
        }

        public void setTraceId(TraceId traceId) {
            this.traceId = traceId;
        }

        public void setHttpInfo(HttpInfo httpInfo) {
            this.httpInfo = httpInfo;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public void setMessageIds(List<String> messageIds) {
            this.messageIds = messageIds;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Info)) {
                return false;
            }
            Info other = (Info)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Tracer this$tracer = this.getTracer();
            Tracer other$tracer = other.getTracer();
            if (this$tracer == null ? other$tracer != null : !((Object)this$tracer).equals(other$tracer)) {
                return false;
            }
            TraceId this$traceId = this.getTraceId();
            TraceId other$traceId = other.getTraceId();
            if (this$traceId == null ? other$traceId != null : !((Object)this$traceId).equals(other$traceId)) {
                return false;
            }
            HttpInfo this$httpInfo = this.getHttpInfo();
            HttpInfo other$httpInfo = other.getHttpInfo();
            if (this$httpInfo == null ? other$httpInfo != null : !((Object)this$httpInfo).equals(other$httpInfo)) {
                return false;
            }
            String this$messageId = this.getMessageId();
            String other$messageId = other.getMessageId();
            if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
                return false;
            }
            List<String> this$messageIds = this.getMessageIds();
            List<String> other$messageIds = other.getMessageIds();
            if (this$messageIds == null ? other$messageIds != null : !((Object)this$messageIds).equals(other$messageIds)) {
                return false;
            }
            String this$resourceName = this.getResourceName();
            String other$resourceName = other.getResourceName();
            if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
                return false;
            }
            String this$targetArn = this.getTargetArn();
            String other$targetArn = other.getTargetArn();
            return !(this$targetArn == null ? other$targetArn != null : !this$targetArn.equals(other$targetArn));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Info;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Tracer $tracer = this.getTracer();
            result = result * 59 + ($tracer == null ? 43 : ((Object)$tracer).hashCode());
            TraceId $traceId = this.getTraceId();
            result = result * 59 + ($traceId == null ? 43 : ((Object)$traceId).hashCode());
            HttpInfo $httpInfo = this.getHttpInfo();
            result = result * 59 + ($httpInfo == null ? 43 : ((Object)$httpInfo).hashCode());
            String $messageId = this.getMessageId();
            result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
            List<String> $messageIds = this.getMessageIds();
            result = result * 59 + ($messageIds == null ? 43 : ((Object)$messageIds).hashCode());
            String $resourceName = this.getResourceName();
            result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
            String $targetArn = this.getTargetArn();
            result = result * 59 + ($targetArn == null ? 43 : $targetArn.hashCode());
            return result;
        }

        public String toString() {
            return "HttpSpan.Info(tracer=" + this.getTracer() + ", traceId=" + this.getTraceId() + ", httpInfo=" + this.getHttpInfo() + ", messageId=" + this.getMessageId() + ", messageIds=" + this.getMessageIds() + ", resourceName=" + this.getResourceName() + ", targetArn=" + this.getTargetArn() + ")";
        }

        public static class InfoBuilder {
            private Tracer tracer;
            private TraceId traceId;
            private HttpInfo httpInfo;
            private String messageId;
            private List<String> messageIds;
            private String resourceName;
            private String targetArn;

            InfoBuilder() {
            }

            public InfoBuilder tracer(Tracer tracer) {
                this.tracer = tracer;
                return this;
            }

            public InfoBuilder traceId(TraceId traceId) {
                this.traceId = traceId;
                return this;
            }

            public InfoBuilder httpInfo(HttpInfo httpInfo) {
                this.httpInfo = httpInfo;
                return this;
            }

            public InfoBuilder messageId(String messageId) {
                this.messageId = messageId;
                return this;
            }

            public InfoBuilder messageIds(List<String> messageIds) {
                this.messageIds = messageIds;
                return this;
            }

            public InfoBuilder resourceName(String resourceName) {
                this.resourceName = resourceName;
                return this;
            }

            public InfoBuilder targetArn(String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            public Info build() {
                return new Info(this.tracer, this.traceId, this.httpInfo, this.messageId, this.messageIds, this.resourceName, this.targetArn);
            }

            public String toString() {
                return "HttpSpan.Info.InfoBuilder(tracer=" + this.tracer + ", traceId=" + this.traceId + ", httpInfo=" + this.httpInfo + ", messageId=" + this.messageId + ", messageIds=" + this.messageIds + ", resourceName=" + this.resourceName + ", targetArn=" + this.targetArn + ")";
            }
        }
    }
}

