/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.handlers;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.lumigo.core.SpansContainer;
import io.lumigo.core.configuration.Configuration;
import io.lumigo.core.instrumentation.agent.Installer;
import io.lumigo.core.network.Reporter;
import io.lumigo.core.utils.EnvUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.pmw.tinylog.Logger;

public abstract class LumigoRequestStreamHandler
implements RequestStreamHandler {
    protected ExecutorService executorService = Executors.newSingleThreadExecutor();
    private EnvUtil envUtil;
    private Reporter reporter;
    private SpansContainer spansContainer;

    public LumigoRequestStreamHandler() {
        try {
            this.envUtil = new EnvUtil();
            this.reporter = new Reporter();
            this.spansContainer = SpansContainer.getInstance();
        }
        catch (RuntimeException ex) {
            Logger.error((Throwable)ex, (String)"Failed to init LumigoRequestStreamHandler");
        }
    }

    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        if (Configuration.getInstance().isKillingSwitchActivated()) {
            this.doHandleRequest(inputStream, outputStream, context);
            return;
        }
        try {
            Logger.debug((String)"Start {} Lumigo tracer", (Object[])new Object[]{LumigoRequestStreamHandler.class.getName()});
            try {
                this.spansContainer.init(this.envUtil.getEnv(), this.reporter, context, null);
                Future<?> submit = this.executorService.submit(() -> Installer.install());
                this.spansContainer.start();
                submit.get();
                Logger.debug((String)"Finish sending start message and instrumentation");
            }
            catch (Throwable ex) {
                Logger.error((Throwable)ex, (String)"Failed to init span container");
            }
            this.doHandleRequest(inputStream, outputStream, context);
            try {
                this.spansContainer.end();
            }
            catch (Throwable ex) {
                Logger.error((Throwable)ex, (String)"Failed to create end span");
            }
        }
        catch (Throwable throwable) {
            Logger.debug((String)"Customer lambda had exception {}", (Object[])new Object[]{throwable.getClass().getName()});
            try {
                this.spansContainer.endWithException(throwable);
            }
            catch (Throwable ex) {
                Logger.error((Throwable)ex, (String)"Failed to create end span");
            }
            throw throwable;
        }
    }

    public abstract void doHandleRequest(InputStream var1, OutputStream var2, Context var3) throws IOException;

    void setEnvUtil(EnvUtil envUtil) {
        this.envUtil = envUtil;
    }

    void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    void setSpansContainer(SpansContainer spansContainer) {
        this.spansContainer = spansContainer;
    }
}

