/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.handlers;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import io.lumigo.core.SpansContainer;
import io.lumigo.core.configuration.Configuration;
import io.lumigo.core.instrumentation.agent.Installer;
import io.lumigo.core.network.Reporter;
import io.lumigo.core.utils.EnvUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.pmw.tinylog.Logger;

public abstract class LumigoRequestHandler<INPUT, OUTPUT>
implements RequestHandler<INPUT, OUTPUT> {
    protected ExecutorService executorService = Executors.newSingleThreadExecutor();
    private EnvUtil envUtil;
    private Reporter reporter;
    private SpansContainer spansContainer;

    public LumigoRequestHandler() {
        try {
            this.envUtil = new EnvUtil();
            this.reporter = new Reporter();
            this.spansContainer = SpansContainer.getInstance();
        }
        catch (RuntimeException ex) {
            Logger.error((Throwable)ex, (String)"Failed to init LumigoRequestHandler");
        }
    }

    public OUTPUT handleRequest(INPUT input, Context context) {
        if (Configuration.getInstance().isKillingSwitchActivated()) {
            return this.doHandleRequest(input, context);
        }
        try {
            Logger.debug((String)"Start {} Lumigo tracer", (Object[])new Object[]{LumigoRequestHandler.class.getName()});
            Logger.debug((String)"Envs {}", (Object[])new Object[]{this.envUtil.getEnv()});
            try {
                this.spansContainer.init(this.envUtil.getEnv(), this.reporter, context, input);
                Future<?> submit = this.executorService.submit(() -> Installer.install());
                this.spansContainer.start();
                submit.get();
                Logger.debug((String)"Finish sending start message and instrumentation");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e, (String)"Failed to init span container");
            }
            OUTPUT response = this.doHandleRequest(input, context);
            try {
                this.spansContainer.end(response);
            }
            catch (Throwable e) {
                Logger.error((Throwable)e, (String)"Failed to create end span");
            }
            return response;
        }
        catch (Throwable throwable) {
            try {
                Logger.debug((String)"Customer lambda had exception {}", (Object[])new Object[]{throwable.getClass().getName()});
                this.spansContainer.endWithException(throwable);
            }
            catch (Throwable ex) {
                Logger.error((Throwable)ex, (String)"Failed to create end span");
            }
            throw throwable;
        }
    }

    public abstract OUTPUT doHandleRequest(INPUT var1, Context var2);

    void setEnvUtil(EnvUtil envUtil) {
        this.envUtil = envUtil;
    }

    void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    void setSpansContainer(SpansContainer spansContainer) {
        this.spansContainer = spansContainer;
    }
}

