/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.lumigo.core.utils.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SecretScrubbingPatternProvider {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final List<String> DEFAULT_PATTERN_STRINGS = Arrays.asList(".*pass.*", ".*key.*", ".*secret.*", ".*credential.*", ".*passphrase.*", "SessionToken", "x-amz-security-token", "Signature", "Authorization");
    private static final List<Pattern> DEFAULT_PATTERNS = SecretScrubbingPatternProvider.stringListToPatterns(DEFAULT_PATTERN_STRINGS);
    private final List<Pattern> scrubbingPatterns;

    private static List<Pattern> stringListToPatterns(List<String> patternStrings) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String patternString : patternStrings) {
            patterns.add(Pattern.compile(patternString, 2));
        }
        return patterns;
    }

    private static List<Pattern> jsonListToPatternList(String jsonList) throws IOException {
        ArrayList<String> patternStrings = new ArrayList<String>();
        try (JsonParser parser = JSON_FACTORY.createParser(jsonList);){
            if (!JsonToken.START_ARRAY.equals((Object)parser.nextToken())) {
                throw new IllegalArgumentException();
            }
            while (!JsonToken.END_ARRAY.equals((Object)parser.nextToken())) {
                if (parser.currentToken().equals((Object)JsonToken.VALUE_STRING)) {
                    patternStrings.add(parser.getText());
                    continue;
                }
                throw new IllegalArgumentException();
            }
            List<Pattern> list = SecretScrubbingPatternProvider.stringListToPatterns(patternStrings);
            return list;
        }
    }

    private List<Pattern> buildBodyScrubbingPatterns(Map<String, String> env) {
        String regexStringifiedList = env.get("LUMIGO_SECRET_MASKING_REGEX");
        if (Strings.isBlank(regexStringifiedList)) {
            return DEFAULT_PATTERNS;
        }
        try {
            return SecretScrubbingPatternProvider.jsonListToPatternList(regexStringifiedList);
        }
        catch (IOException e) {
            return DEFAULT_PATTERNS;
        }
    }

    public List<Pattern> getScrubbingPatterns() {
        return this.scrubbingPatterns;
    }

    public SecretScrubbingPatternProvider(Map<String, String> env) {
        this.scrubbingPatterns = this.buildBodyScrubbingPatterns(env);
    }
}

