/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.utils;

import io.lumigo.core.utils.SecretScrubbingPatternProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class SecretScrubber {
    private List<Pattern> scrubbingPatterns;
    private static final String SECRET_PLACEHOLDER = "****";

    public SecretScrubber(Map<String, String> env) {
        this.scrubbingPatterns = new SecretScrubbingPatternProvider(env).getScrubbingPatterns();
    }

    public String scrubStringifiedObject(String stringifiedObject) {
        try {
            JSONObject jsonObject = new JSONObject(stringifiedObject);
            return this.scrubJsonObject(jsonObject, this.scrubbingPatterns).toString();
        }
        catch (Exception e) {
            return stringifiedObject;
        }
    }

    private JSONObject scrubJsonObject(JSONObject jsonObject, List<Pattern> patterns) {
        for (String key : jsonObject.keySet()) {
            Object value = jsonObject.get(key);
            if (value instanceof String && this.isSecret(key, patterns)) {
                jsonObject.put(key, (Object)SECRET_PLACEHOLDER);
                continue;
            }
            if (value instanceof JSONArray) {
                ArrayList<String> scrubbedArray = new ArrayList<String>();
                for (Object item : (JSONArray)value) {
                    if (item instanceof String && this.isSecret(key, patterns)) {
                        scrubbedArray.add(SECRET_PLACEHOLDER);
                        continue;
                    }
                    if (item instanceof JSONObject) {
                        scrubbedArray.add((String)this.scrubJsonObject((JSONObject)item, patterns));
                        continue;
                    }
                    scrubbedArray.add((String)item);
                }
                jsonObject.put(key, (Object)scrubbedArray.toArray());
                continue;
            }
            if (!(value instanceof JSONObject)) continue;
            jsonObject.put(key, (Object)this.scrubJsonObject((JSONObject)value, patterns));
        }
        return jsonObject;
    }

    private boolean isSecret(String value, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(value).matches()) continue;
            return true;
        }
        return false;
    }
}

