/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.utils;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.CloudFrontEvent;
import com.amazonaws.services.lambda.runtime.events.CloudWatchLogsEvent;
import com.amazonaws.services.lambda.runtime.events.CodeCommitEvent;
import com.amazonaws.services.lambda.runtime.events.CognitoEvent;
import com.amazonaws.services.lambda.runtime.events.ConfigEvent;
import com.amazonaws.services.lambda.runtime.events.DynamodbEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisAnalyticsFirehoseInputPreprocessingEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisAnalyticsStreamsInputPreprocessingEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisFirehoseEvent;
import com.amazonaws.services.lambda.runtime.events.LexEvent;
import com.amazonaws.services.lambda.runtime.events.S3Event;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.amazonaws.services.lambda.runtime.events.ScheduledEvent;
import com.amazonaws.services.s3.event.S3EventNotification;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.lumigo.core.utils.StringUtils;
import io.lumigo.models.Span;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pmw.tinylog.Logger;

public class AwsUtils {
    public static final String COLD_START_KEY = "LUMIGO_COLD_START_KEY";
    private static final String TRIGGERED_BY_FALLBACK = "No recognized trigger";
    private static final int MAXIMAL_NUMBER_OF_MESSAGE_IDS = 50;

    public static String extractAwsAccountFromArn(String arn) {
        String[] arnParts = arn.split(":");
        if (arnParts.length < 7) {
            return null;
        }
        return arnParts[4];
    }

    public static TriggeredBy extractTriggeredByFromEvent(Object event) {
        TriggeredBy triggeredBy = new TriggeredBy();
        try {
            Logger.info((String)"Trying to find triggered by to event from class {}", (Object[])new Object[]{event != null ? event.getClass().getName() : null});
            if (event == null) {
                return null;
            }
            if (event instanceof DynamodbEvent) {
                triggeredBy.setTriggeredBy("dynamodb");
                if (((DynamodbEvent)event).getRecords() != null && ((DynamodbEvent)event).getRecords().size() > 0) {
                    List<String> messageIds;
                    DynamodbEvent.DynamodbStreamRecord firstRecord = (DynamodbEvent.DynamodbStreamRecord)((DynamodbEvent)event).getRecords().get(0);
                    triggeredBy.setArn(firstRecord.getEventSourceARN());
                    if (firstRecord.getDynamodb() != null && firstRecord.getDynamodb().getApproximateCreationDateTime() != null) {
                        triggeredBy.setApproxEventCreationTime(firstRecord.getDynamodb().getApproximateCreationDateTime().getTime());
                    }
                    if ((messageIds = ((DynamodbEvent)event).getRecords().stream().map(AwsUtils::extractMessageIdFromDynamodbRecord).filter(Objects::nonNull).limit(50L).collect(Collectors.toList())).size() > 0) {
                        triggeredBy.setMessageIds(messageIds);
                    }
                }
            } else if (event instanceof KinesisEvent) {
                triggeredBy.setTriggeredBy("kinesis");
                if (((KinesisEvent)event).getRecords() != null && ((KinesisEvent)event).getRecords().size() > 0) {
                    List records = ((KinesisEvent)event).getRecords();
                    triggeredBy.setArn(((KinesisEvent.KinesisEventRecord)records.get(0)).getEventSourceARN());
                    List<String> messageIds = records.stream().map(kinesisEventRecord -> kinesisEventRecord.getKinesis().getSequenceNumber()).collect(Collectors.toList());
                    triggeredBy.setMessageId(((KinesisEvent.KinesisEventRecord)records.get(0)).getKinesis().getSequenceNumber());
                    triggeredBy.setMessageIds(messageIds);
                }
            } else if (event instanceof KinesisFirehoseEvent) {
                triggeredBy.setTriggeredBy("kinesis");
                triggeredBy.setArn(((KinesisFirehoseEvent)event).getDeliveryStreamArn());
            } else if (event instanceof KinesisAnalyticsFirehoseInputPreprocessingEvent) {
                triggeredBy.setTriggeredBy("kinesis");
                triggeredBy.setArn(((KinesisAnalyticsFirehoseInputPreprocessingEvent)event).getStreamArn());
            } else if (event instanceof KinesisAnalyticsStreamsInputPreprocessingEvent) {
                triggeredBy.setTriggeredBy("kinesis");
                triggeredBy.setArn(((KinesisAnalyticsStreamsInputPreprocessingEvent)event).getStreamArn());
            } else if (AwsUtils.instanceofByName(event, "S3Event")) {
                triggeredBy.setTriggeredBy("s3");
                if (((S3Event)event).getRecords() != null && ((S3Event)event).getRecords().size() > 0) {
                    triggeredBy.setArn(((S3EventNotification.S3EventNotificationRecord)((S3Event)event).getRecords().get(0)).getS3().getBucket().getArn());
                }
            } else if (event instanceof SNSEvent) {
                triggeredBy.setTriggeredBy("sns");
                if (((SNSEvent)event).getRecords() != null && ((SNSEvent)event).getRecords().size() > 0) {
                    triggeredBy.setArn(((SNSEvent.SNSRecord)((SNSEvent)event).getRecords().get(0)).getSNS().getTopicArn());
                    triggeredBy.setMessageId(((SNSEvent.SNSRecord)((SNSEvent)event).getRecords().get(0)).getSNS().getMessageId());
                }
            } else if (event instanceof SQSEvent) {
                triggeredBy.setTriggeredBy("sqs");
                if (((SQSEvent)event).getRecords() != null && ((SQSEvent)event).getRecords().size() > 0) {
                    triggeredBy.setArn(((SQSEvent.SQSMessage)((SQSEvent)event).getRecords().get(0)).getEventSourceArn());
                    triggeredBy.setMessageId(((SQSEvent.SQSMessage)((SQSEvent)event).getRecords().get(0)).getMessageId());
                }
            } else if (event instanceof APIGatewayProxyRequestEvent) {
                triggeredBy.setTriggeredBy("apigw");
                triggeredBy.setHttpMethod(((APIGatewayProxyRequestEvent)event).getHttpMethod());
                triggeredBy.setResource(((APIGatewayProxyRequestEvent)event).getResource());
                if (((APIGatewayProxyRequestEvent)event).getHeaders() != null) {
                    triggeredBy.setApi(((APIGatewayProxyRequestEvent)event).getHeaders().getOrDefault("Host", "unknown.unknown.unknown"));
                }
                if (((APIGatewayProxyRequestEvent)event).getRequestContext() != null && ((APIGatewayProxyRequestEvent)event).getRequestContext().getStage() != null) {
                    triggeredBy.setStage(((APIGatewayProxyRequestEvent)event).getRequestContext().getStage());
                }
            } else if (event instanceof CloudWatchLogsEvent) {
                triggeredBy.setTriggeredBy("cloudwatch");
            } else if (event instanceof ScheduledEvent) {
                triggeredBy.setTriggeredBy("cloudwatch");
                if (((ScheduledEvent)event).getResources() != null && ((ScheduledEvent)event).getResources().size() > 0) {
                    triggeredBy.setArn((String)((ScheduledEvent)event).getResources().get(0));
                }
            } else if (event instanceof CloudFrontEvent) {
                triggeredBy.setTriggeredBy("cloudfront");
            } else if (event instanceof ConfigEvent) {
                triggeredBy.setTriggeredBy("config");
            } else if (event instanceof CodeCommitEvent) {
                triggeredBy.setTriggeredBy("codecommit");
            } else if (event instanceof LexEvent) {
                triggeredBy.setTriggeredBy("lex");
            } else if (event instanceof CognitoEvent) {
                triggeredBy.setTriggeredBy("cognito");
            } else {
                Logger.info((String)"Failed to found relevant triggered by found for event {} ", (Object[])new Object[]{event.getClass().getName()});
                triggeredBy.setTriggeredBy(TRIGGERED_BY_FALLBACK);
                return triggeredBy;
            }
            Logger.info((String)"Found triggered by handler to event {}", (Object[])new Object[]{event.getClass().getName()});
            return triggeredBy;
        }
        catch (Throwable e) {
            Logger.error((Throwable)e, (String)"Failed to extract triggerBy data");
            triggeredBy.setTriggeredBy(TRIGGERED_BY_FALLBACK);
            return triggeredBy;
        }
    }

    public static String extractAwsTraceRoot(String amznTraceId) {
        Matcher matcher = Pattern.compile("([^;]+)=([^;]*)").matcher(amznTraceId);
        while (matcher.find()) {
            if (!matcher.group(1).equals("Root")) continue;
            return matcher.group(2);
        }
        return null;
    }

    public static String extractAwsTraceTransactionId(String amznTraceId) {
        String root = AwsUtils.extractAwsTraceRoot(amznTraceId);
        if (root == null) {
            return null;
        }
        String[] rootParts = root.split("-");
        if (rootParts.length < 3) {
            return null;
        }
        return rootParts[2];
    }

    public static String extractAwsTraceSuffix(String amznTraceId) {
        if (!amznTraceId.contains(";")) {
            return amznTraceId;
        }
        return amznTraceId.substring(amznTraceId.indexOf(";"));
    }

    public static synchronized Span.READINESS getFunctionReadiness() {
        if (System.getProperty(COLD_START_KEY) != null) {
            return Span.READINESS.WARM;
        }
        System.setProperty(COLD_START_KEY, "false");
        return Span.READINESS.COLD;
    }

    public static int parseJavaVersion(String version) {
        try {
            String[] parts = version.split("\\.");
            if (parts[0].equals("1")) {
                return Integer.parseInt(parts[1]);
            }
            return Integer.parseInt(parts[0]);
        }
        catch (Exception e) {
            Logger.error((String)"Failed to parse java version", (Object[])new Object[]{e});
            return -1;
        }
    }

    private static boolean instanceofByName(Object event, String className) {
        for (Class<?> c = event.getClass(); c != null; c = c.getSuperclass()) {
            if (!c.getSimpleName().equals(className)) continue;
            return true;
        }
        return false;
    }

    private static String extractMessageIdFromDynamodbRecord(DynamodbEvent.DynamodbStreamRecord record) {
        if (record.getEventName() == null) {
            return null;
        }
        if (record.getEventName().equals("INSERT")) {
            return StringUtils.dynamodbItemToHash(record.getDynamodb().getNewImage());
        }
        if (record.getEventName().equals("MODIFY") || record.getEventName().equals("REMOVE")) {
            return StringUtils.dynamodbItemToHash(record.getDynamodb().getKeys());
        }
        return null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class TriggeredBy {
        private String triggeredBy;
        private String arn;
        private String httpMethod;
        private String resource;
        private String api;
        private String stage;
        private String messageId;
        private List<String> messageIds = Collections.emptyList();
        private long approxEventCreationTime = 0L;

        public List<String> getMessageIds() {
            if (this.messageIds != null) {
                return this.messageIds;
            }
            return Collections.emptyList();
        }

        public void setMessageIds(List<String> messageIds) {
            this.messageIds = messageIds;
        }

        public String getTriggeredBy() {
            return this.triggeredBy;
        }

        public String getArn() {
            return this.arn;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public String getResource() {
            return this.resource;
        }

        public String getApi() {
            return this.api;
        }

        public String getStage() {
            return this.stage;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public long getApproxEventCreationTime() {
            return this.approxEventCreationTime;
        }

        public void setTriggeredBy(String triggeredBy) {
            this.triggeredBy = triggeredBy;
        }

        public void setArn(String arn) {
            this.arn = arn;
        }

        public void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public void setApi(String api) {
            this.api = api;
        }

        public void setStage(String stage) {
            this.stage = stage;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public void setApproxEventCreationTime(long approxEventCreationTime) {
            this.approxEventCreationTime = approxEventCreationTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TriggeredBy)) {
                return false;
            }
            TriggeredBy other = (TriggeredBy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getApproxEventCreationTime() != other.getApproxEventCreationTime()) {
                return false;
            }
            String this$triggeredBy = this.getTriggeredBy();
            String other$triggeredBy = other.getTriggeredBy();
            if (this$triggeredBy == null ? other$triggeredBy != null : !this$triggeredBy.equals(other$triggeredBy)) {
                return false;
            }
            String this$arn = this.getArn();
            String other$arn = other.getArn();
            if (this$arn == null ? other$arn != null : !this$arn.equals(other$arn)) {
                return false;
            }
            String this$httpMethod = this.getHttpMethod();
            String other$httpMethod = other.getHttpMethod();
            if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
                return false;
            }
            String this$resource = this.getResource();
            String other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
                return false;
            }
            String this$api = this.getApi();
            String other$api = other.getApi();
            if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
                return false;
            }
            String this$stage = this.getStage();
            String other$stage = other.getStage();
            if (this$stage == null ? other$stage != null : !this$stage.equals(other$stage)) {
                return false;
            }
            String this$messageId = this.getMessageId();
            String other$messageId = other.getMessageId();
            if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
                return false;
            }
            List<String> this$messageIds = this.getMessageIds();
            List<String> other$messageIds = other.getMessageIds();
            return !(this$messageIds == null ? other$messageIds != null : !((Object)this$messageIds).equals(other$messageIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TriggeredBy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $approxEventCreationTime = this.getApproxEventCreationTime();
            result = result * 59 + (int)($approxEventCreationTime >>> 32 ^ $approxEventCreationTime);
            String $triggeredBy = this.getTriggeredBy();
            result = result * 59 + ($triggeredBy == null ? 43 : $triggeredBy.hashCode());
            String $arn = this.getArn();
            result = result * 59 + ($arn == null ? 43 : $arn.hashCode());
            String $httpMethod = this.getHttpMethod();
            result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
            String $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
            String $api = this.getApi();
            result = result * 59 + ($api == null ? 43 : $api.hashCode());
            String $stage = this.getStage();
            result = result * 59 + ($stage == null ? 43 : $stage.hashCode());
            String $messageId = this.getMessageId();
            result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
            List<String> $messageIds = this.getMessageIds();
            result = result * 59 + ($messageIds == null ? 43 : ((Object)$messageIds).hashCode());
            return result;
        }

        public String toString() {
            return "AwsUtils.TriggeredBy(triggeredBy=" + this.getTriggeredBy() + ", arn=" + this.getArn() + ", httpMethod=" + this.getHttpMethod() + ", resource=" + this.getResource() + ", api=" + this.getApi() + ", stage=" + this.getStage() + ", messageId=" + this.getMessageId() + ", messageIds=" + this.getMessageIds() + ", approxEventCreationTime=" + this.getApproxEventCreationTime() + ")";
        }
    }
}

