/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.utils;

import io.lumigo.core.utils.JsonUtils;
import io.lumigo.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public final class AwsSdkV2Utils {
    public static String calculateItemHash(Map<String, AttributeValue> item) {
        Map<String, Object> simpleMap = AwsSdkV2Utils.convertAttributeMapToSimpleMap(item);
        return StringUtils.buildMd5Hash(JsonUtils.getObjectAsJsonString(simpleMap));
    }

    public static Map<String, Object> convertAttributeMapToSimpleMap(Map<String, AttributeValue> attributeValueMap) {
        HashMap<String, Object> simpleMap = new HashMap<String, Object>();
        attributeValueMap.forEach((key, value) -> simpleMap.put((String)key, AwsSdkV2Utils.attributeValueToObject(value)));
        return simpleMap;
    }

    private static Object attributeValueToObject(AttributeValue value) {
        if (value == null) {
            return null;
        }
        if (value.s() != null) {
            return value.s();
        }
        if (value.n() != null) {
            return value.n();
        }
        if (value.bool() != null) {
            return value.bool();
        }
        if (value.l() != null && !value.l().isEmpty()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (AttributeValue v : value.l()) {
                list.add(AwsSdkV2Utils.attributeValueToObject(v));
            }
            return list;
        }
        if (value.m() != null && !value.m().isEmpty()) {
            return AwsSdkV2Utils.convertAttributeMapToSimpleMap(value.m());
        }
        return null;
    }

    private AwsSdkV2Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

