/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.parsers.v2;

import io.lumigo.core.parsers.v2.AwsSdkV2Parser;
import io.lumigo.models.HttpSpan;
import org.pmw.tinylog.Logger;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.services.sns.model.PublishResponse;

public class SnsV2Parser
implements AwsSdkV2Parser {
    @Override
    public String getParserType() {
        return SnsV2Parser.class.getName();
    }

    @Override
    public void parse(HttpSpan span, Context.AfterExecution context) {
        if (context.request().getValueForField("TopicArn", String.class).isPresent()) {
            context.request().getValueForField("TopicArn", String.class).ifPresent(topicArn -> {
                Logger.debug((String)("Parsed topicArn : " + topicArn));
                span.getInfo().setResourceName((String)topicArn);
                span.getInfo().setTargetArn((String)topicArn);
            });
        } else {
            Logger.warn((String)"Failed to extract topicArn");
        }
        span.getInfo().setMessageId(this.extractMessageId(context.response()));
    }

    private String extractMessageId(SdkResponse response) {
        try {
            if (response instanceof PublishResponse) {
                return ((PublishResponse)response).messageId();
            }
            Logger.error((String)"Failed to extract messageId for SNS response");
            return null;
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Failed to extract messageId for SNS response");
            return null;
        }
    }
}

