/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.parsers.v2;

import io.lumigo.core.parsers.v2.AwsSdkV2Parser;
import io.lumigo.models.HttpSpan;
import java.util.LinkedList;
import java.util.List;
import org.pmw.tinylog.Logger;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;

public class KinesisV2Parser
implements AwsSdkV2Parser {
    @Override
    public String getParserType() {
        return KinesisV2Parser.class.getName();
    }

    @Override
    public void parse(HttpSpan span, Context.AfterExecution context) {
        List<String> messageIds;
        if (context.request().getValueForField("StreamName", String.class).isPresent()) {
            context.request().getValueForField("StreamName", String.class).ifPresent(streamName -> {
                span.getInfo().setResourceName((String)streamName);
                Logger.debug((String)("Parsed StreamName : " + streamName));
            });
        }
        if (!(messageIds = this.extractMessageIds(context.response())).isEmpty()) {
            span.getInfo().setMessageIds(messageIds);
        }
    }

    private List<String> extractMessageIds(Object response) {
        LinkedList<String> messageIds = new LinkedList<String>();
        if (response instanceof PutRecordsResponse) {
            ((PutRecordsResponse)response).records().forEach(putRecordsResultEntry -> messageIds.add(putRecordsResultEntry.sequenceNumber()));
            return messageIds;
        }
        if (response instanceof PutRecordResponse) {
            messageIds.add(((PutRecordResponse)response).sequenceNumber());
            return messageIds;
        }
        Logger.error((String)"Failed to extract messageIds for Kinesis response");
        return messageIds;
    }
}

