/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.parsers.v2;

import io.lumigo.core.parsers.v2.AwsSdkV2Parser;
import io.lumigo.core.utils.AwsSdkV2Utils;
import io.lumigo.models.HttpSpan;
import java.util.List;
import java.util.Map;
import org.pmw.tinylog.Logger;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public class DynamoDBV2Parser
implements AwsSdkV2Parser {
    @Override
    public String getParserType() {
        return DynamoDBV2Parser.class.getName();
    }

    @Override
    public void parse(HttpSpan span, Context.AfterExecution context) {
        SdkRequest request = context.request();
        if (context.request().getValueForField("TableName", String.class).isPresent()) {
            context.request().getValueForField("TableName", String.class).ifPresent(tableName -> {
                span.getInfo().setResourceName((String)tableName);
                Logger.debug((String)("Parsed TableName : " + tableName));
            });
        } else if (request instanceof BatchWriteItemRequest && ((BatchWriteItemRequest)request).hasRequestItems()) {
            ((BatchWriteItemRequest)request).requestItems().keySet().stream().findFirst().ifPresent(tableName -> {
                span.getInfo().setResourceName((String)tableName);
                Logger.debug((String)("Parsed TableName : " + tableName));
            });
        } else if (request instanceof BatchGetItemRequest) {
            ((BatchGetItemRequest)request).requestItems().keySet().stream().findFirst().ifPresent(tableName -> {
                span.getInfo().setResourceName((String)tableName);
                Logger.debug((String)("Parsed TableName : " + tableName));
            });
        } else {
            Logger.warn((String)"Failed to extract TableName form DynamoDB request");
        }
        span.getInfo().setMessageId(this.extractMessageId(context.request()));
    }

    private String extractMessageId(SdkRequest request) {
        if (request instanceof PutItemRequest) {
            return AwsSdkV2Utils.calculateItemHash(((PutItemRequest)request).item());
        }
        if (request instanceof UpdateItemRequest) {
            return AwsSdkV2Utils.calculateItemHash(((UpdateItemRequest)request).key());
        }
        if (request instanceof DeleteItemRequest) {
            return AwsSdkV2Utils.calculateItemHash(((DeleteItemRequest)request).key());
        }
        if (request instanceof BatchWriteItemRequest) {
            Map requests = ((BatchWriteItemRequest)request).requestItems();
            WriteRequest firstRequest = (WriteRequest)((List)requests.entrySet().iterator().next().getValue()).get(0);
            if (firstRequest.putRequest() != null) {
                return AwsSdkV2Utils.calculateItemHash(firstRequest.putRequest().item());
            }
            if (firstRequest.deleteRequest() != null) {
                return AwsSdkV2Utils.calculateItemHash(firstRequest.deleteRequest().key());
            }
        }
        return null;
    }
}

