/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.parsers.v1;

import io.lumigo.core.parsers.v1.AwsSdkV1Parser;
import io.lumigo.core.parsers.v1.DoNothingV1Parser;
import io.lumigo.core.parsers.v1.DynamoDBV1Parser;
import io.lumigo.core.parsers.v1.KinesisV1Parser;
import io.lumigo.core.parsers.v1.SnsV1Parser;
import io.lumigo.core.parsers.v1.SqsV1Parser;

public class AwsSdkV1ParserFactory {
    public static AwsSdkV1Parser getParser(String serviceName) {
        if (serviceName == null) {
            return new DoNothingV1Parser();
        }
        switch (serviceName) {
            case "AmazonSNS": {
                return new SnsV1Parser();
            }
            case "AmazonSQS": {
                return new SqsV1Parser();
            }
            case "AmazonKinesis": {
                return new KinesisV1Parser();
            }
            case "AmazonDynamoDB": 
            case "AmazonDynamoDBv2": {
                return new DynamoDBV1Parser();
            }
        }
        return new DoNothingV1Parser();
    }
}

