/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.parsers.event;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import io.lumigo.core.parsers.event.IEventParser;
import io.lumigo.core.parsers.event.SqsEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SqsEventParser
implements IEventParser<SQSEvent> {
    @Override
    public Object parse(SQSEvent event) {
        LinkedList<SqsEvent.Record> records = new LinkedList<SqsEvent.Record>();
        for (SQSEvent.SQSMessage rec : event.getRecords()) {
            HashMap<String, SqsEvent.MessageAttribute> attributes = new HashMap<String, SqsEvent.MessageAttribute>();
            for (Map.Entry attributeEntry : rec.getMessageAttributes().entrySet()) {
                attributes.put((String)attributeEntry.getKey(), SqsEvent.MessageAttribute.builder().type(((SQSEvent.MessageAttribute)attributeEntry.getValue()).getDataType()).value(((SQSEvent.MessageAttribute)attributeEntry.getValue()).getStringValue()).build());
            }
            records.add(SqsEvent.Record.builder().body(rec.getBody()).messageAttributes(attributes).messageId(rec.getMessageId()).build());
        }
        return SqsEvent.builder().records(records).build();
    }
}

