/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.parsers.event;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import io.lumigo.core.parsers.event.APIGWEvent;
import io.lumigo.core.parsers.event.IEventParser;
import io.lumigo.core.utils.EnvUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class APIGWEventParser
implements IEventParser<APIGatewayProxyRequestEvent> {
    private static final String LUMIGO_API_GW_PREFIX_KEYS_HEADERS_DELETE_KEYS = "LUMIGO_API_GW_PREFIX_KEYS_HEADERS_DELETE_KEYS";
    private EnvUtil envUtil = new EnvUtil();
    private String[] HEADERS_REMOVE_KEYS_DEFUALT = new String[]{"cookie", "x-amz", "accept", "cloudfront", "via", "x-forwarded", "sec-"};
    private String[] HEADERS_REMOVE_KEYS = this.envUtil.getStringArrayEnv("LUMIGO_API_GW_PREFIX_KEYS_HEADERS_DELETE_KEYS", this.HEADERS_REMOVE_KEYS_DEFUALT);

    @Override
    public Object parse(APIGatewayProxyRequestEvent event) {
        return APIGWEvent.builder().path(event.getPath()).body(event.getBody()).resource(event.getResource()).httpMethod(event.getHttpMethod()).stageVariables(event.getStageVariables()).pathParameters(event.getPathParameters()).queryStringParameters(event.getQueryStringParameters()).authorizer(event.getRequestContext().getAuthorizer()).headers(this.removeHeadersKeys(event.getHeaders())).build();
    }

    private Map<String, String> removeHeadersKeys(Map<String, String> headers) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<String, String> e : headers.entrySet()) {
            if (!Stream.of(this.HEADERS_REMOVE_KEYS).noneMatch(s -> ((String)e.getKey()).toLowerCase().startsWith((String)s))) continue;
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    public void setEnvUtil(EnvUtil envUtil) {
        this.envUtil = envUtil;
    }
}

