/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.network;

import io.lumigo.core.configuration.Configuration;
import io.lumigo.core.utils.JsonUtils;
import io.lumigo.core.utils.StringUtils;
import io.lumigo.models.Reportable;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.pmw.tinylog.Logger;

public class Reporter {
    private OkHttpClient client = new OkHttpClient.Builder().callTimeout(Configuration.getInstance().getLumigoTimeout()).build();

    public long reportSpans(Reportable span, int maxSize) throws IOException {
        return this.reportSpans(Collections.singletonList(span), maxSize);
    }

    public long reportSpans(List<Reportable> spans, int maxSize) throws IOException {
        long time = System.currentTimeMillis();
        LinkedList<String> spansAsStringList = new LinkedList<String>();
        int sizeCount = 0;
        int handledSpans = 0;
        for (Reportable span : spans) {
            if (sizeCount >= maxSize) {
                Logger.debug((String)"Dropped spans by request size: {}", (Object[])new Object[]{spans.size() - handledSpans});
                break;
            }
            String spanAsString = JsonUtils.getObjectAsJsonString(span);
            if (spanAsString != null) {
                spansAsStringList.add(spanAsString);
                sizeCount += StringUtils.getBase64Size(spanAsString);
            }
            ++handledSpans;
        }
        if (Configuration.getInstance().isAwsEnvironment() && spansAsStringList.size() > 0) {
            String spansAsString = "[" + String.join((CharSequence)",", spansAsStringList) + "]";
            Logger.debug((String)"Reporting the spans: {}", (Object[])new Object[]{spansAsString});
            RequestBody body = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)spansAsString);
            Request request = new Request.Builder().header("Accept", "application/json").url(Configuration.getInstance().getLumigoEdge()).post(body).build();
            Response response = this.client.newCall(request).execute();
            if (response.body() != null) {
                response.body().close();
            }
            return System.currentTimeMillis() - time;
        }
        return 0L;
    }
}

