/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.instrumentation.impl;

import io.lumigo.core.SpansContainer;
import io.lumigo.core.instrumentation.LumigoInstrumentationApi;
import io.lumigo.core.instrumentation.agent.Loader;
import io.lumigo.core.utils.LRUCache;
import java.util.List;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.pmw.tinylog.Logger;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpRequest;

public class AmazonHttpClientV2Instrumentation
implements LumigoInstrumentationApi {
    @Override
    public ElementMatcher<TypeDescription> getTypeMatcher() {
        return ElementMatchers.named((String)"software.amazon.awssdk.core.client.builder.SdkDefaultClientBuilder");
    }

    @Override
    public AgentBuilder.Transformer.ForAdvice getTransformer() {
        return new AgentBuilder.Transformer.ForAdvice().include(new ClassLoader[]{Loader.class.getClassLoader()}).advice((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"resolveExecutionInterceptors")), AmazonHttpClientV2Advice.class.getName());
    }

    public static class AmazonHttpClientV2Advice {
        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void methodExit(@Advice.Return List<ExecutionInterceptor> interceptors) {
            Logger.debug((String)"Added Lumigo TracingExecutionInterceptor");
            for (ExecutionInterceptor interceptor : interceptors) {
                if (!(interceptor instanceof TracingExecutionInterceptor)) continue;
                return;
            }
            interceptors.add(new TracingExecutionInterceptor());
        }

        public static class TracingExecutionInterceptor
        implements ExecutionInterceptor {
            public static final SpansContainer spansContainer = SpansContainer.getInstance();
            public static final LRUCache<Integer, Boolean> handled = new LRUCache(1000);
            public static final LRUCache<Integer, Long> startTimeMap = new LRUCache(1000);

            public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
                startTimeMap.put(context.request().hashCode(), System.currentTimeMillis());
            }

            public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
                try {
                    SdkHttpRequest.Builder requestBuilder = (SdkHttpRequest.Builder)context.httpRequest().toBuilder();
                    requestBuilder.appendHeader("X-Amzn-Trace-Id", spansContainer.getPatchedRoot());
                    return (SdkHttpRequest)requestBuilder.build();
                }
                catch (Throwable e) {
                    Logger.debug((String)"Unable to inject trace header", (Object[])new Object[]{e});
                    return context.httpRequest();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
                try {
                    if (handled.get(context.request().hashCode()) == null) {
                        Logger.info((String)"Handling request {} from host {}", (Object[])new Object[]{context.request().hashCode()});
                        spansContainer.addHttpSpan((Long)startTimeMap.get(context.request().hashCode()), context, executionAttributes);
                        handled.put(context.request().hashCode(), true);
                    } else {
                        Logger.warn((String)"Already handle request {} for host {}", (Object[])new Object[]{context.request().hashCode(), context.httpRequest().host()});
                    }
                }
                catch (Throwable e) {
                    Logger.error((Throwable)e, (String)"Failed to send data on http response");
                }
                finally {
                    startTimeMap.remove(context.request().hashCode());
                }
            }
        }
    }
}

