/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.instrumentation.agent;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import io.lumigo.core.configuration.Configuration;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import org.pmw.tinylog.Logger;

public class Installer {
    private static boolean firstStart = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void install() {
        if (Configuration.getInstance().isAwsEnvironment() && Configuration.getInstance().isInstrumentationEnabled() && firstStart) {
            firstStart = false;
            Logger.info((String)"Agent installation start");
            List<VirtualMachineDescriptor> vms = VirtualMachine.list();
            String agentPath = Installer.findAgentPath();
            Logger.info((String)"Loading agent jar: {}", (Object[])new Object[]{agentPath});
            for (VirtualMachineDescriptor vmd : vms) {
                try {
                    VirtualMachine vm = VirtualMachine.attach(vmd.id());
                    try {
                        if (agentPath.contains("lib")) {
                            vm.loadAgent(agentPath, "lib");
                            continue;
                        }
                        vm.loadAgent(agentPath);
                    }
                    finally {
                        vm.detach();
                    }
                }
                catch (Throwable e) {
                    Logger.error((Throwable)e, (String)"Fail to attach agent, no instrumentation");
                }
            }
        } else {
            Logger.info((String)"Agent installation is skipped, isAwsEnvironment: {}, isInstrumentationEnabled: {}, isFirstStart: {}", (Object[])new Object[]{Configuration.getInstance().isAwsEnvironment(), Configuration.getInstance().isInstrumentationEnabled(), firstStart});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findAgentPath() {
        if (!Files.notExists(Paths.get("/var/task/lumigo-agent.jar", new String[0]), new LinkOption[0])) return "/var/task/lumigo-agent.jar";
        Logger.info((String)"Agent jar was not found under /var/task/lumigo-agent.jar, try to find it under /var/task/lib");
        try (Stream<Path> paths = Files.walk(Paths.get("/var/task/lib", new String[0]), new FileVisitOption[0]);){
            Path lumigoAgentPath = paths.filter(p -> p.toFile().getAbsolutePath().contains("lumigo-agent")).findFirst().get();
            String string = lumigoAgentPath.toFile().getAbsolutePath();
            return string;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return "/var/task/lumigo-agent.jar";
        }
    }
}

