/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.services.lambda.runtime.Context;
import io.lumigo.core.configuration.Configuration;
import io.lumigo.core.network.Reporter;
import io.lumigo.core.parsers.event.EventParserFactory;
import io.lumigo.core.parsers.v1.AwsSdkV1ParserFactory;
import io.lumigo.core.parsers.v2.AwsSdkV2ParserFactory;
import io.lumigo.core.utils.AwsUtils;
import io.lumigo.core.utils.EnvUtil;
import io.lumigo.core.utils.JsonUtils;
import io.lumigo.core.utils.SecretScrubber;
import io.lumigo.core.utils.StringUtils;
import io.lumigo.models.HttpSpan;
import io.lumigo.models.Reportable;
import io.lumigo.models.Span;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.pmw.tinylog.Logger;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.sync.RequestBody;

public class SpansContainer {
    private static final int MAX_STRING_SIZE = Configuration.getInstance().maxSpanFieldSize();
    private static final int MAX_REQUEST_SIZE = Configuration.getInstance().maxRequestSize();
    private static final int MAX_LAMBDA_TIME = 900000;
    private static final String AWS_EXECUTION_ENV = "AWS_EXECUTION_ENV";
    private static final String AWS_REGION = "AWS_REGION";
    private static final String AMZN_TRACE_ID = "_X_AMZN_TRACE_ID";
    private static final String FUNCTION_SPAN_TYPE = "function";
    private static final String HTTP_SPAN_TYPE = "http";
    private static final SecretScrubber secretScrubber = new SecretScrubber(new EnvUtil().getEnv());
    private Span baseSpan;
    private Span startFunctionSpan;
    private Long rttDuration;
    private Span endFunctionSpan;
    private Reporter reporter;
    private List<HttpSpan> httpSpans = new LinkedList<HttpSpan>();
    private static final SpansContainer ourInstance = new SpansContainer();
    private String awsTracerId;

    public static SpansContainer getInstance() {
        return ourInstance;
    }

    public void clear() {
        this.baseSpan = null;
        this.startFunctionSpan = null;
        this.rttDuration = null;
        this.endFunctionSpan = null;
        this.reporter = null;
        this.httpSpans = new LinkedList<HttpSpan>();
    }

    private SpansContainer() {
    }

    public void init(Map<String, String> env, Reporter reporter, Context context, Object event) {
        this.clear();
        this.reporter = reporter;
        int javaVersion = AwsUtils.parseJavaVersion(System.getProperty("java.version"));
        this.awsTracerId = javaVersion > 11 ? System.getProperty("com.amazonaws.xray.traceHeader") : env.get(AMZN_TRACE_ID);
        Logger.debug((String)"awsTracerId {}", (Object[])new Object[]{this.awsTracerId});
        AwsUtils.TriggeredBy triggeredBy = AwsUtils.extractTriggeredByFromEvent(event);
        long startTime = System.currentTimeMillis();
        this.baseSpan = Span.builder().token(Configuration.getInstance().getLumigoToken()).id(context.getAwsRequestId()).started(startTime).name(context.getFunctionName()).runtime(env.get(AWS_EXECUTION_ENV)).region(env.get(AWS_REGION)).memoryAllocated(String.valueOf(context.getMemoryLimitInMB())).requestId(context.getAwsRequestId()).account(AwsUtils.extractAwsAccountFromArn(context.getInvokedFunctionArn())).maxFinishTime(startTime + (long)(context.getRemainingTimeInMillis() > 0 ? context.getRemainingTimeInMillis() : 900000)).transactionId(AwsUtils.extractAwsTraceTransactionId(this.awsTracerId)).info(Span.Info.builder().tracer(Span.Tracer.builder().version(Configuration.getInstance().getLumigoTracerVersion()).build()).traceId(Span.TraceId.builder().root(AwsUtils.extractAwsTraceRoot(this.awsTracerId)).build()).triggeredBy(triggeredBy != null ? triggeredBy.getTriggeredBy() : null).api(triggeredBy != null ? triggeredBy.getApi() : null).arn(triggeredBy != null ? triggeredBy.getArn() : null).httpMethod(triggeredBy != null ? triggeredBy.getHttpMethod() : null).resource(triggeredBy != null ? triggeredBy.getResource() : null).stage(triggeredBy != null ? triggeredBy.getStage() : null).messageId(triggeredBy != null ? triggeredBy.getMessageId() : null).messageIds(triggeredBy != null ? triggeredBy.getMessageIds() : null).approxEventCreationTime(triggeredBy != null ? triggeredBy.getApproxEventCreationTime() : 0L).logGroupName(context.getLogGroupName()).logStreamName(context.getLogStreamName()).build()).type(FUNCTION_SPAN_TYPE).readiness(AwsUtils.getFunctionReadiness().toString()).envs(Configuration.getInstance().isLumigoVerboseMode() ? JsonUtils.getObjectAsJsonString(env) : null).event(Configuration.getInstance().isLumigoVerboseMode() ? JsonUtils.getObjectAsJsonString(EventParserFactory.parseEvent(event)) : null).build();
    }

    public void start() {
        this.startFunctionSpan = this.baseSpan.toBuilder().id(this.baseSpan.getId() + "_started").ended(this.baseSpan.getStarted()).build();
        try {
            this.rttDuration = this.reporter.reportSpans(this.prepareToSend(this.startFunctionSpan, false), MAX_REQUEST_SIZE);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e, (String)"Failed to send start span");
        }
    }

    public void end(Object response) throws IOException {
        this.end(this.baseSpan.toBuilder().return_value(Configuration.getInstance().isLumigoVerboseMode() ? JsonUtils.getObjectAsJsonString(response) : null).build());
    }

    public void endWithException(Throwable e) throws IOException {
        this.end(this.baseSpan.toBuilder().error(Span.Error.builder().message(e.getMessage()).type(e.getClass().getName()).stacktrace(this.getStackTrace(e)).build()).build());
    }

    public void end() throws IOException {
        this.end(this.baseSpan);
    }

    private void end(Span endFunctionSpan) throws IOException {
        this.endFunctionSpan = endFunctionSpan.toBuilder().reporter_rtt(this.rttDuration).ended(System.currentTimeMillis()).id(this.baseSpan.getId()).build();
        this.reporter.reportSpans(this.prepareToSend(this.getAllCollectedSpans(), endFunctionSpan.getError() != null), MAX_REQUEST_SIZE);
    }

    public Span getStartFunctionSpan() {
        return this.startFunctionSpan;
    }

    public List<Reportable> getAllCollectedSpans() {
        LinkedList<Reportable> spans = new LinkedList<Reportable>();
        spans.add(this.endFunctionSpan);
        spans.addAll(this.httpSpans);
        return spans;
    }

    public Span getEndSpan() {
        return this.endFunctionSpan;
    }

    public List<HttpSpan> getHttpSpans() {
        return this.httpSpans;
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private HttpSpan createBaseHttpSpan(Long startTime) {
        return HttpSpan.builder().id(UUID.randomUUID().toString()).started(startTime).ended(System.currentTimeMillis()).transactionId(this.baseSpan.getTransactionId()).account(this.baseSpan.getAccount()).region(this.baseSpan.getRegion()).token(this.baseSpan.getToken()).type(HTTP_SPAN_TYPE).parentId(this.baseSpan.getRequestId()).info(HttpSpan.Info.builder().tracer(HttpSpan.Tracer.builder().version(this.baseSpan.getInfo().getTracer().getVersion()).build()).traceId(HttpSpan.TraceId.builder().root(this.baseSpan.getInfo().getTraceId().getRoot()).build()).build()).build();
    }

    public void addHttpSpan(Long startTime, HttpUriRequest request, HttpResponse response) {
        HttpSpan httpSpan = this.createBaseHttpSpan(startTime);
        httpSpan.getInfo().setHttpInfo(HttpSpan.HttpInfo.builder().host(request.getURI().getHost()).request(HttpSpan.HttpData.builder().headers(SpansContainer.callIfVerbose(() -> SpansContainer.extractHeaders(request.getAllHeaders()))).uri(SpansContainer.callIfVerbose(() -> request.getURI().toString())).method(request.getMethod()).body(SpansContainer.callIfVerbose(() -> SpansContainer.extractBodyFromRequest(request))).build()).response(HttpSpan.HttpData.builder().headers(SpansContainer.callIfVerbose(() -> SpansContainer.extractHeaders(response.getAllHeaders()))).body(SpansContainer.callIfVerbose(() -> SpansContainer.extractBodyFromResponse(response))).statusCode(response.getStatusLine().getStatusCode()).build()).build());
        this.httpSpans.add(httpSpan);
    }

    public void addHttpSpan(Long startTime, Request<?> request, Response<?> response) {
        HttpSpan httpSpan = this.createBaseHttpSpan(startTime);
        String spanId = null;
        for (Map.Entry header : response.getHttpResponse().getHeaders().entrySet()) {
            if (!"x-amzn-requestid".equalsIgnoreCase((String)header.getKey()) && !"x-amz-requestid".equalsIgnoreCase((String)header.getKey())) continue;
            spanId = (String)header.getValue();
        }
        if (spanId != null) {
            httpSpan.setId(spanId);
        }
        httpSpan.getInfo().setHttpInfo(HttpSpan.HttpInfo.builder().host(request.getEndpoint().getHost()).request(HttpSpan.HttpData.builder().headers(SpansContainer.callIfVerbose(() -> SpansContainer.extractHeaders(request.getHeaders()))).uri(SpansContainer.callIfVerbose(() -> request.getEndpoint().toString())).method(request.getHttpMethod().name()).body(SpansContainer.callIfVerbose(() -> SpansContainer.extractBodyFromRequest(request))).build()).response(HttpSpan.HttpData.builder().headers(SpansContainer.callIfVerbose(() -> SpansContainer.extractHeaders(response.getHttpResponse().getHeaders()))).body(SpansContainer.callIfVerbose(() -> SpansContainer.extractBodyFromResponse(response))).statusCode(response.getHttpResponse().getStatusCode()).build()).build());
        AwsSdkV1ParserFactory.getParser(request.getServiceName()).safeParse(httpSpan, request, response);
        this.httpSpans.add(httpSpan);
    }

    public void addHttpSpan(Long startTime, Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        HttpSpan httpSpan = this.createBaseHttpSpan(startTime);
        String spanId = null;
        for (Map.Entry header : context.httpResponse().headers().entrySet()) {
            if (!"x-amzn-requestid".equalsIgnoreCase((String)header.getKey()) && !"x-amz-requestid".equalsIgnoreCase((String)header.getKey())) continue;
            spanId = (String)((List)header.getValue()).get(0);
        }
        if (spanId != null) {
            httpSpan.setId(spanId);
        }
        httpSpan.getInfo().setHttpInfo(HttpSpan.HttpInfo.builder().host(context.httpRequest().getUri().getHost()).request(HttpSpan.HttpData.builder().headers(SpansContainer.callIfVerbose(() -> SpansContainer.extractHeadersV2(context.httpRequest().headers()))).uri(SpansContainer.callIfVerbose(() -> context.httpRequest().getUri().toString())).method(context.httpRequest().method().name()).body(SpansContainer.callIfVerbose(() -> SpansContainer.extractBodyFromRequest(context.requestBody()))).build()).response(HttpSpan.HttpData.builder().headers(SpansContainer.callIfVerbose(() -> SpansContainer.extractHeadersV2(context.httpResponse().headers()))).body(SpansContainer.callIfVerbose(() -> SpansContainer.extractBodyFromResponse(context.response()))).statusCode(context.httpResponse().statusCode()).build()).build());
        Logger.debug((String)("Trying to extract aws custom properties for service: " + (String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME)));
        AwsSdkV2ParserFactory.getParser((String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME)).safeParse(httpSpan, context);
        this.httpSpans.add(httpSpan);
    }

    private static String extractHeaders(Map<String, String> headers) {
        return JsonUtils.getObjectAsJsonString(headers);
    }

    private static String extractHeadersV2(Map<String, List<String>> headers) {
        return JsonUtils.getObjectAsJsonString(headers);
    }

    private static String extractHeaders(Header[] headers) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (headers != null) {
            for (Header header : headers) {
                headersMap.put(header.getName(), header.getValue());
            }
        }
        return SpansContainer.extractHeaders(headersMap);
    }

    protected static String extractBodyFromRequest(Request<?> request) {
        return SpansContainer.extractBodyFromStream(request.getContent());
    }

    protected static String extractBodyFromRequest(Optional<RequestBody> request) {
        return request.map(requestBody -> SpansContainer.extractBodyFromStream(requestBody.contentStreamProvider().newStream())).orElse(null);
    }

    protected static String extractBodyFromRequest(HttpUriRequest request) throws Exception {
        HttpEntity entity;
        if (request instanceof HttpEntityEnclosingRequestBase && (entity = ((HttpEntityEnclosingRequestBase)request).getEntity()) != null) {
            return SpansContainer.extractBodyFromStream(entity.getContent());
        }
        return null;
    }

    protected static String extractBodyFromResponse(HttpResponse response) throws IOException {
        return response.getEntity() != null ? SpansContainer.extractBodyFromStream(response.getEntity().getContent()) : null;
    }

    protected static String extractBodyFromResponse(Response response) {
        return response.getAwsResponse() != null ? JsonUtils.getObjectAsJsonString(response.getAwsResponse()) : null;
    }

    protected static String extractBodyFromResponse(SdkResponse response) {
        if (response instanceof AwsResponse) {
            return JsonUtils.getObjectAsJsonString(response.toBuilder());
        }
        return null;
    }

    protected static String extractBodyFromStream(InputStream stream) {
        return StringUtils.extractStringForStream(stream, MAX_STRING_SIZE);
    }

    public String getPatchedRoot() {
        return String.format("Root=%s-0000%s-%s%s", AwsUtils.extractAwsTraceRoot(this.awsTracerId), StringUtils.randomStringAndNumbers(4), AwsUtils.extractAwsTraceTransactionId(this.awsTracerId), AwsUtils.extractAwsTraceSuffix(this.awsTracerId));
    }

    protected static <T> T callIfVerbose(Callable<T> method) {
        if (!Configuration.getInstance().isLumigoVerboseMode()) {
            return null;
        }
        try {
            return method.call();
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Failed to call method");
            return null;
        }
    }

    private Reportable prepareToSend(Reportable span, boolean hasError) {
        return this.reduceSpanSize(span.scrub(secretScrubber), hasError);
    }

    private List<Reportable> prepareToSend(List<Reportable> spans, boolean hasError) {
        for (Reportable span : spans) {
            this.reduceSpanSize(span.scrub(secretScrubber), hasError);
        }
        return spans;
    }

    public Reportable reduceSpanSize(Reportable span, boolean hasError) {
        int maxFieldSize = hasError ? Configuration.getInstance().maxSpanFieldSizeWhenError() : Configuration.getInstance().maxSpanFieldSize();
        return span.reduceSize(maxFieldSize);
    }
}

