package io.lsn.spring.rest.configuration.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "io.lsn.spring.rest")
public class RestConfigurationProperties {
    private long readTimeoutSeconds = 20;
    private long connectTimeoutSeconds = 20;

    public long getReadTimeoutSeconds() {
        return readTimeoutSeconds;
    }

    public RestConfigurationProperties setReadTimeoutSeconds(long readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
        return this;
    }

    public long getConnectTimeoutSeconds() {
        return connectTimeoutSeconds;
    }

    public RestConfigurationProperties setConnectTimeoutSeconds(long connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return this;
    }
}
