/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.rest.helper;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class LoggingInterceptor
implements ClientHttpRequestInterceptor {
    protected Logger logger = LoggerFactory.getLogger(LoggingInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.logger.debug(Stream.of(request.getMethod().toString(), request.getURI().toString(), request.getHeaders().toString(), new String(body, this.determineCharset(request.getHeaders()))).collect(Collectors.joining(" ")));
        ClientHttpResponse response = execution.execute(request, body);
        this.logger.debug(response.getStatusCode().toString());
        this.logger.debug(response.getStatusText());
        this.logger.debug(StreamUtils.copyToString((InputStream)response.getBody(), (Charset)Charset.forName(StandardCharsets.UTF_8.name())));
        return response;
    }

    protected Charset determineCharset(HttpHeaders headers) {
        MediaType contentType = headers.getContentType();
        if (contentType != null && contentType.getCharset() != null) {
            return contentType.getCharset();
        }
        return StandardCharsets.UTF_8;
    }
}

