/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.rest;

import io.lsn.spring.rest.helper.LoggingInterceptor;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RestClient {
    private RestTemplateBuilder restTemplateBuilder;

    @Autowired
    public RestClient(RestTemplateBuilder restTemplateBuilder) {
        this.restTemplateBuilder = restTemplateBuilder;
    }

    protected RestTemplate buildRestTemplate() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        BufferingClientHttpRequestFactory bufferingClientHttpRequestFactory = new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)requestFactory);
        requestFactory.setOutputStreaming(false);
        RestTemplate restTemplate = this.restTemplateBuilder.additionalMessageConverters(new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter()}).interceptors(new ClientHttpRequestInterceptor[]{new LoggingInterceptor()}).build();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)bufferingClientHttpRequestFactory);
        return restTemplate;
    }

    public <K, T> ResponseEntity<T> get(String url, Class<T> responseClass) {
        return this.buildRestTemplate().exchange(URI.create(url), HttpMethod.GET, this.buildHttpEntity(null), responseClass);
    }

    public <K, T> ResponseEntity<T> post(String url, K request, Class<T> responseClass) {
        return this.buildRestTemplate().exchange(URI.create(url), HttpMethod.POST, this.buildHttpEntity(request), responseClass);
    }

    public <K, T> ResponseEntity<T> put(String url, K request, Class<T> responseClass) {
        return this.buildRestTemplate().exchange(URI.create(url), HttpMethod.PUT, this.buildHttpEntity(request), responseClass);
    }

    protected <T> HttpEntity<T> buildHttpEntity(T requestClass) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        if (requestClass != null) {
            return new HttpEntity(requestClass, (MultiValueMap)headers);
        }
        return new HttpEntity((MultiValueMap)headers);
    }
}

