package io.lsn.spring.rest.helper;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LoggingInterceptor implements ClientHttpRequestInterceptor {

    protected Logger logger = LoggerFactory.getLogger(LoggingInterceptor.class);

    /**
     * przechwytuje informacje o danym Zapytaniu/Odpowiedzi
     *
     * @param request
     * @param body
     * @param execution
     * @return
     * @throws IOException
     */
    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        logger.debug(
                Stream.of(request.getMethod().toString(),
                        request.getURI().toString(),
                        request.getHeaders().toString(),
                        new String(body, determineCharset(request.getHeaders()))
                ).collect(Collectors.joining(" "))
        );
        ClientHttpResponse response = execution.execute(request, body);
        logger.debug(response.getStatusCode().toString());
        logger.debug(response.getStatusText());
        logger.debug(StreamUtils.copyToString(response.getBody(), Charset.forName(StandardCharsets.UTF_8.name())));
        return response;
    }

    /**
     * pobiera charset dla danego Zapytania/Odpowiedzi
     *
     * @param headers
     * @return
     */
    protected Charset determineCharset(HttpHeaders headers) {
        MediaType contentType = headers.getContentType();
        if (contentType != null && contentType.getCharset() != null) {
            return contentType.getCharset();
        } else {
            return StandardCharsets.UTF_8;
        }
    }
}
