package io.lsn.spring.rest.helper;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LoggingInterceptor implements ClientHttpRequestInterceptor {

    protected Logger logger = LoggerFactory.getLogger(LoggingInterceptor.class);

    /**
     * przechwytuje informacje o danym Zapytaniu/Odpowiedzi
     *
     * @param request
     * @param body
     * @param execution
     * @return
     * @throws IOException
     */
    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        logger.info(
                Stream.of(request.getMethod().toString(),
                        request.getURI().toString(),
                        request.getHeaders().toString(),
                        new String(body, determineCharset(request.getHeaders()))
                ).collect(Collectors.joining(" "))
        );
        ClientHttpResponse response = execution.execute(request, body);
        logger.info(response.getStatusCode().toString());
        logger.info(response.getStatusText());

        StringBuilder textBuilder = new StringBuilder();
        try (Reader reader = new BufferedReader(new InputStreamReader
                (response.getBody(), Charset.forName(StandardCharsets.UTF_8.name())))) {
            int c = 0;
            while ((c = reader.read()) != -1) {
                textBuilder.append((char) c);
            }
        }

        logger.info(textBuilder.toString());
        return response;
    }

    /**
     * pobiera charset dla danego Zapytania/Odpowiedzi
     *
     * @param headers
     * @return
     */
    protected Charset determineCharset(HttpHeaders headers) {
        MediaType contentType = headers.getContentType();
        if (contentType != null && contentType.getCharset() != null) {
            return contentType.getCharset();
        } else {
            return StandardCharsets.UTF_8;
        }
    }
}
