package io.lsn.logbook.configuration.entity;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@ConfigurationProperties(prefix = "io.lsn.spring.logbook")
public class LogProperties {
    private List<String> jsonExclusions = Arrays.asList("password", "password2");
    private String replaceTo = "<secret>";

    public List<String> getJsonExclusions() {
        if (jsonExclusions == null) {
            jsonExclusions = new ArrayList<>();
        }
        return jsonExclusions;
    }

    public LogProperties setJsonExclusions(List<String> jsonExclusions) {
        this.jsonExclusions = jsonExclusions;
        return this;
    }

    public String getReplaceTo() {
        return replaceTo;
    }

    public LogProperties setReplaceTo(String replaceTo) {
        this.replaceTo = replaceTo;
        return this;
    }
}
